import opendreams.proxy.OpenDreamsException;
import opendreams.proxy.OpenDreamsProxy;
import opendreams.proxy.Project;
import tecgraf.openbus.DRMAA.AlreadyActiveSessionException;
import tecgraf.openbus.DRMAA.AuthorizationException;
import tecgraf.openbus.DRMAA.DefaultContactStringException;
import tecgraf.openbus.DRMAA.DeniedByDrmException;
import tecgraf.openbus.DRMAA.DrmCommunicationException;
import tecgraf.openbus.DRMAA.DrmsExitException;
import tecgraf.openbus.DRMAA.DrmsInitException;
import tecgraf.openbus.DRMAA.ExitTimeoutException;
import tecgraf.openbus.DRMAA.InternalException;
import tecgraf.openbus.DRMAA.InvalidArgumentException;
import tecgraf.openbus.DRMAA.InvalidContactStringException;
import tecgraf.openbus.DRMAA.InvalidJobException;
import tecgraf.openbus.DRMAA.InvalidJobTemplateException;
import tecgraf.openbus.DRMAA.NoActiveSessionException;
import tecgraf.openbus.DRMAA.NoDefaultContactStringSelectedException;
import tecgraf.openbus.DRMAA.OutOfMemoryException;
import tecgraf.openbus.DRMAA.Session;
import tecgraf.openbus.DRMAA.TryLaterException;
import tecgraf.openbus.opendreams.IOpenDreams;
import tecgraf.openbus.opendreams.OpenDreamsJobInfo;
import tecgraf.openbus.opendreams.OpenDreamsJobTemplate;

/**
 * Teste de acesso ao servio OpenDreams do OpenBus.
 * 
 * Esse teste executa um fluxo cadastrado como um algoritmo no repositrio.
 * 
 * @author Tecgraf PUC-Rio
 * 
 */
public class FlowDemoOpenDreams {

  public static final String INPUT_FILE_PARAMETER = "EntradaFlow.txt";
  public static final String OUTPUT1_FILE_PARAMETER = "SaidaFlow1.txt";
  public static final String OUTPUT2_FILE_PARAMETER = "SaidaFlow2.txt";
  public static final String LOG_FILE = "log_myflow.log";

  public static void main(String[] args) throws Exception {
    new FlowDemoOpenDreams().run();
  }

  private void run() {
    try {
      OpenDreamsProxy opendreamsProxy = new OpenDreamsProxy();
      opendreamsProxy.init();
      prepareProjectFiles(opendreamsProxy);
      System.out.println("** Recuperando o componente OpenDreams...");
      IOpenDreams opendreams = opendreamsProxy.getIOpenDreams();
      Session session = opendreams.getSession(opendreamsProxy.getProjectName());
      session.init("");
      OpenDreamsJobTemplate jt =
        (OpenDreamsJobTemplate) session.createJobTemplate();
      jt.remoteCommand = "execAlgo";
      jt.args = new String[] { "-name", "Fluxo", "-version", "1.0.0" };
      jt.jobDescription = "Teste da Julia";
      jt.jobParameters =
        new String[][] { { "1.SLEEP", "4" }, { "1.EXIT_CODE", "5" },
            { "1.ENTRADA1", INPUT_FILE_PARAMETER + ":TEXT" },
            { "3.SLEEP", "5" }, { "3.EXIT_CODE", "0" },
            { "3.SAIDA1", OUTPUT1_FILE_PARAMETER + ":TEXT" },
            { "5.SLEEP", "6" }, { "5.EXIT_CODE", "0" },
            { "5.SAIDA1", OUTPUT2_FILE_PARAMETER + ":TEXT" } };
      jt.outputPath = LOG_FILE;
      jt.email = new String[] { "mjulia@tecgraf.puc-rio.br" };
      System.out.println("** Solicitando a execucao de " + jt.remoteCommand);
      System.out.print("** Argumentos: ");
      for (String arg : jt.args) {
        System.out.print(arg);
        System.out.print(" ");
      }
      System.out.println("** Parmetros: ");
      for (String[] parameters : jt.jobParameters) {
        System.out.println(parameters[0] + "=" + parameters[1]);
      }
      System.out.println("** OutputPath: " + jt.outputPath);
      String jobName = session.runJob(jt);
      System.out.println("** Id do comando: " + jobName);
      session.deleteJobTemplate(jt);

      OpenDreamsJobInfo jobInfo =
        (OpenDreamsJobInfo) session
          ._wait(jobName, Session.TIMEOUT_WAIT_FOREVER);
      System.out.println("** Resultado: hasExited = " + jobInfo.hasExited
        + ", exitStatus = " + jobInfo.exitStatus + ", algorithmId = "
        + jobInfo.guiltyNodeId);
      Project project = opendreamsProxy.getProject();
      byte[] buffer = project.getDataFrom(LOG_FILE);
      System.out.println("** O log do comando e:");
      System.out.println(new String(buffer));
      session.exit();
      opendreamsProxy.close();
    }
    catch (OpenDreamsException e) {
      e.printStackTrace();
    }
    catch (AuthorizationException e) {
      handleException(e.message, e);
    }
    catch (InternalException e) {
      handleException(e.message, e);
    }
    catch (InvalidContactStringException e) {
      handleException(e.message, e);
    }
    catch (NoDefaultContactStringSelectedException e) {
      handleException(e.message, e);
    }
    catch (DefaultContactStringException e) {
      handleException(e.message, e);
    }
    catch (DrmCommunicationException e) {
      handleException(e.message, e);
    }
    catch (DrmsInitException e) {
      handleException(e.message, e);
    }
    catch (AlreadyActiveSessionException e) {
      handleException(e.message, e);
    }
    catch (OutOfMemoryException e) {
      handleException(e.message, e);
    }
    catch (InvalidArgumentException e) {
      handleException(e.message, e);
    }
    catch (TryLaterException e) {
      handleException(e.message, e);
    }
    catch (NoActiveSessionException e) {
      handleException(e.message, e);
    }
    catch (DeniedByDrmException e) {
      handleException(e.message, e);
    }
    catch (InvalidJobTemplateException e) {
      handleException(e.message, e);
    }
    catch (InvalidJobException e) {
      handleException(e.message, e);
    }
    catch (ExitTimeoutException e) {
      handleException(e.message, e);
    }
    catch (DrmsExitException e) {
      handleException(e.message, e);
    }
  }

  private void handleException(String message, Exception e) {
    e.initCause(new Exception(message));
    e.printStackTrace();
  }

  private void prepareProjectFiles(OpenDreamsProxy opendreamsProxy)
    throws OpenDreamsException {
    Project project = opendreamsProxy.getProject();
    if (project == null) {
      System.out.println("Projeto no encontrado");
      return;
    }
    /*
     * Criando o arquivo de entrada no projeto. Se o arquivo j existir, ele 
     * removido antes de ser criado um novo.
     */
    String inputFileName = INPUT_FILE_PARAMETER;
    if (project.hasFile(inputFileName)) {
      System.out.println("** Removendo o arquivo " + inputFileName
        + " que j existe");
      project.removeFile(inputFileName);
    }
    String content = "Arquivo de entrada para teste do fluxo\n";
    System.out.println("** Criando um arquivo no projeto...");
    project.createFile(inputFileName, content.getBytes());

    /*
     * Removendo os arquivos de sada no projeto, no caso deles j existirem.
     */
    System.out.println("** Removendo os arquivos de saida do projeto...");
    String outputFileName = OUTPUT1_FILE_PARAMETER;
    if (project.hasFile(outputFileName)) {
      System.out.println("** Removendo o arquivo " + outputFileName
        + " que j existe");
      project.removeFile(outputFileName);
    }
    outputFileName = OUTPUT2_FILE_PARAMETER;
    if (project.hasFile(outputFileName)) {
      System.out.println("** Removendo o arquivo " + outputFileName
        + " que j existe");
      project.removeFile(outputFileName);
    }
  }
}
