/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.LifecycleManager;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.ComponentMonitorStrategy;
import org.picocontainer.defaults.LifecycleStrategy;

public class DecoratingComponentAdapter
implements ComponentAdapter,
ComponentMonitorStrategy,
LifecycleManager,
LifecycleStrategy,
Serializable {
    private ComponentAdapter delegate;

    public DecoratingComponentAdapter(ComponentAdapter componentAdapter) {
        this.delegate = componentAdapter;
    }

    public Object getComponentKey() {
        return this.delegate.getComponentKey();
    }

    public Class getComponentImplementation() {
        return this.delegate.getComponentImplementation();
    }

    public Object getComponentInstance(PicoContainer picoContainer) throws PicoInitializationException, PicoIntrospectionException {
        return this.delegate.getComponentInstance(picoContainer);
    }

    public void verify(PicoContainer picoContainer) throws PicoIntrospectionException {
        this.delegate.verify(picoContainer);
    }

    public ComponentAdapter getDelegate() {
        return this.delegate;
    }

    public void accept(PicoVisitor picoVisitor) {
        picoVisitor.visitComponentAdapter(this);
        this.delegate.accept(picoVisitor);
    }

    public void changeMonitor(ComponentMonitor componentMonitor) {
        if (this.delegate instanceof ComponentMonitorStrategy) {
            ((ComponentMonitorStrategy)((Object)this.delegate)).changeMonitor(componentMonitor);
        }
    }

    public ComponentMonitor currentMonitor() {
        if (this.delegate instanceof ComponentMonitorStrategy) {
            return ((ComponentMonitorStrategy)((Object)this.delegate)).currentMonitor();
        }
        throw new PicoIntrospectionException("No component monitor found in delegate");
    }

    public void start(PicoContainer picoContainer) {
        if (this.delegate instanceof LifecycleManager) {
            ((LifecycleManager)((Object)this.delegate)).start(picoContainer);
        }
    }

    public void stop(PicoContainer picoContainer) {
        if (this.delegate instanceof LifecycleManager) {
            ((LifecycleManager)((Object)this.delegate)).stop(picoContainer);
        }
    }

    public void dispose(PicoContainer picoContainer) {
        if (this.delegate instanceof LifecycleManager) {
            ((LifecycleManager)((Object)this.delegate)).dispose(picoContainer);
        }
    }

    public boolean hasLifecycle() {
        if (this.delegate instanceof LifecycleManager) {
            return ((LifecycleManager)((Object)this.delegate)).hasLifecycle();
        }
        if (this.delegate instanceof LifecycleStrategy) {
            return ((LifecycleStrategy)((Object)this.delegate)).hasLifecycle(this.delegate.getComponentImplementation());
        }
        return false;
    }

    public void start(Object object) {
        if (this.delegate instanceof LifecycleStrategy) {
            ((LifecycleStrategy)((Object)this.delegate)).start(object);
        }
    }

    public void stop(Object object) {
        if (this.delegate instanceof LifecycleStrategy) {
            ((LifecycleStrategy)((Object)this.delegate)).stop(object);
        }
    }

    public void dispose(Object object) {
        if (this.delegate instanceof LifecycleStrategy) {
            ((LifecycleStrategy)((Object)this.delegate)).dispose(object);
        }
    }

    public boolean hasLifecycle(Class clazz) {
        if (this.delegate instanceof LifecycleStrategy) {
            return ((LifecycleStrategy)((Object)this.delegate)).hasLifecycle(clazz);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        stringBuffer.append(this.getPrintableClassName());
        stringBuffer.append(" delegate=");
        stringBuffer.append(this.delegate);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private String getPrintableClassName() {
        String string = this.getClass().getName();
        if ((string = string.substring(string.lastIndexOf(46) + 1)).endsWith("ComponentAdapter")) {
            string = string.substring(0, string.length() - "ComponentAdapter".length()) + "CA";
        }
        return string;
    }
}

