/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.lease;

import java.util.Date;
import openbusidl.acs.Credential;
import openbusidl.acs.ILeaseProvider;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.SystemException;
import tecgraf.openbus.lease.LeaseExpiredCallback;
import tecgraf.openbus.util.Log;

public final class LeaseRenewer {
    private static final int DEFAULT_LEASE = 30;
    private ILeaseProvider leaseProvider;
    private RenewerTask renewer;

    public LeaseRenewer(Credential credential, ILeaseProvider leaseProvider, LeaseExpiredCallback expiredCallback) {
        this.leaseProvider = leaseProvider;
        this.renewer = new RenewerTask(credential, this.leaseProvider, expiredCallback);
    }

    public void setProvider(ILeaseProvider leaseProvider) {
        this.leaseProvider = leaseProvider;
        this.renewer.setProvider(this.leaseProvider);
    }

    public void setLeaseExpiredCallback(LeaseExpiredCallback lec) {
        this.renewer.expiredCallback = lec;
    }

    public void start() {
        this.renewer.start();
    }

    public void finish() {
        this.renewer.finish();
    }

    private static class RenewerTask
    extends Thread {
        private Credential credential;
        private ILeaseProvider provider;
        private LeaseExpiredCallback expiredCallback;
        private boolean mustContinue;

        RenewerTask(Credential credential, ILeaseProvider provider) {
            this.credential = credential;
            this.provider = provider;
            this.mustContinue = true;
        }

        RenewerTask(Credential credential, ILeaseProvider provider, LeaseExpiredCallback expiredCallback) {
            this(credential, provider);
            this.expiredCallback = expiredCallback;
        }

        public void run() {
            int lease = 30;
            while (this.mustContinue) {
                IntHolder newLease = new IntHolder();
                try {
                    boolean expired;
                    try {
                        expired = !this.provider.renewLease(this.credential, newLease);
                    }
                    catch (NO_PERMISSION ne) {
                        expired = true;
                    }
                    if (expired) {
                        Log.LEASE.warning("Falha na renova\u00e7\u00e3o da credencial.");
                        if (this.expiredCallback != null) {
                            this.expiredCallback.expired();
                        }
                        this.mustContinue = false;
                    } else {
                        StringBuilder msg = new StringBuilder();
                        msg.append(new Date());
                        msg.append(" - Lease renovado. Pr\u00f3xima renova\u00e7\u00e3o em ");
                        msg.append(newLease.value);
                        msg.append(" segundos.");
                        Log.LEASE.fine(msg.toString());
                        lease = newLease.value;
                    }
                }
                catch (SystemException e) {
                    Log.LEASE.severe(e.getMessage(), e);
                }
                if (!this.mustContinue) continue;
                try {
                    Thread.sleep(lease * 1000);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void finish() {
            this.mustContinue = false;
        }

        public void setProvider(ILeaseProvider provider) {
            this.provider = provider;
        }
    }
}

