/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc.server.states;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc.common.exception.InvalidArraySize;
import tecgraf.ftc.common.logic.ErrorCode;
import tecgraf.ftc.common.logic.PrimitiveTypeSize;
import tecgraf.ftc.server.AccessKey;
import tecgraf.ftc.server.FileChannelRequestInfo;
import tecgraf.ftc.server.FileServer;
import tecgraf.ftc.server.Session;
import tecgraf.ftc.server.states.GetOperationState;
import tecgraf.ftc.server.states.State;

public final class ValidateKeyState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private byte keySize;
    private byte[] key;
    private ErrorCode errorCode;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");

    public ValidateKeyState() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Estado de valida\u00e7\u00e3o de chave.");
        }
    }

    public boolean read(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.keySize = buffer.get();
                buffer.clear();
                this.currentState = InternalState.KEY_SIZE_RECEIVED;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Tamanho da chave lido " + this.keySize);
                }
            }
            case KEY_SIZE_RECEIVED: {
                buffer.limit(this.keySize);
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.key = new byte[this.keySize];
                buffer.get(this.key);
                buffer.clear();
                this.currentState = InternalState.KEY_RECEIVED;
                FileServer fileServer = session.getFileServer();
                AccessKey accessKey = null;
                try {
                    accessKey = new AccessKey(this.key);
                }
                catch (InvalidArraySize e) {
                    this.errorCode = ErrorCode.INVALID_KEY;
                }
                FileChannelRequestInfo fileChannelInfo = fileServer.getFileChannelInfo(accessKey);
                if (fileChannelInfo == null) {
                    this.errorCode = ErrorCode.INVALID_KEY;
                    break;
                }
                this.errorCode = ErrorCode.OK;
                session.setFileChannelInfo(fileChannelInfo);
            }
        }
        return true;
    }

    public boolean write(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case KEY_RECEIVED: {
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                buffer.put(this.errorCode.getCode());
                buffer.flip();
                try {
                    if (channel.write(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                buffer.clear();
                this.currentState = InternalState.ERROR_CODE_SENT;
                if (this.errorCode.equals((Object)ErrorCode.OK)) {
                    session.setCurrentState(new GetOperationState());
                } else {
                    session.setCurrentState(null);
                }
                if (!logger.isLoggable(Level.FINER)) break;
                logger.finer("C\u00f3digo " + (Object)((Object)this.errorCode) + " enviado.");
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum InternalState {
        INITIAL,
        KEY_SIZE_RECEIVED,
        KEY_RECEIVED,
        ERROR_CODE_SENT;

    }
}

