/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc.server.states;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc.common.logic.PrimitiveTypeSize;
import tecgraf.ftc.server.FileChannelRequestInfo;
import tecgraf.ftc.server.FileServer;
import tecgraf.ftc.server.Session;
import tecgraf.ftc.server.states.GetOperationState;
import tecgraf.ftc.server.states.State;
import tecgraf.ftc.utils.IOUtils;

public final class ReadState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private long position;
    private long count;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    public static final long MAX_BYTES = Integer.MAX_VALUE;
    private long bytesSent = 0L;

    public ReadState() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Estado de leitura.");
        }
    }

    public boolean read(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.position = buffer.getLong();
                buffer.clear();
                this.currentState = InternalState.POSITION_READ;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Position " + this.position);
                }
            }
            case POSITION_READ: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.count = buffer.getLong();
                buffer.clear();
                this.currentState = InternalState.BYTE_COUNT_READ;
                if (!logger.isLoggable(Level.FINER)) break;
                logger.finer("Quantidade pedida " + this.count);
            }
        }
        return true;
    }

    public boolean write(Session session) {
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case BYTE_COUNT_READ: {
                ByteBuffer buffer = session.getBuffer();
                FileChannel fileChannel = session.getFileChannel();
                FileChannelRequestInfo fileInfo = session.getFileChannelInfo();
                long bytesWritten = 0L;
                try {
                    long bytesToread = this.count - this.bytesSent;
                    if (fileInfo.useTransferTo() && (this.count <= Integer.MAX_VALUE || !FileServer.PLATAFORM_HAS_TRANSFERTO_BUG)) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("Using TransferTo");
                        }
                        bytesWritten = fileChannel.transferTo(this.position + this.bytesSent, bytesToread, channel);
                    } else {
                        bytesWritten = IOUtils.transferToNonBlock(fileChannel, this.position + this.bytesSent, bytesToread, channel, buffer);
                        buffer.clear();
                    }
                    if (bytesWritten > 0L) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    buffer.clear();
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    return false;
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Enviados " + bytesWritten);
                }
                this.bytesSent += bytesWritten;
                if (this.bytesSent == this.count) {
                    this.currentState = InternalState.BYTES_SENT;
                    session.setCurrentState(new GetOperationState());
                }
                return true;
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum InternalState {
        INITIAL,
        POSITION_READ,
        BYTE_COUNT_READ,
        BYTES_SENT;

    }
}

