/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc.server.states;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc.common.exception.FailureException;
import tecgraf.ftc.common.exception.PermissionException;
import tecgraf.ftc.common.logic.ErrorCode;
import tecgraf.ftc.common.logic.PrimitiveTypeSize;
import tecgraf.ftc.server.FileChannelRequestInfo;
import tecgraf.ftc.server.FileServer;
import tecgraf.ftc.server.Session;
import tecgraf.ftc.server.states.GetOperationState;
import tecgraf.ftc.server.states.State;

public abstract class OpenState
implements State {
    private InternalState currentState;
    private byte fileIdSize;
    private byte[] fileId;
    private FileChannel fileChannel;
    private ErrorCode errorCode;
    private boolean readOnly;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");

    protected OpenState(boolean readOnly) {
        this.readOnly = readOnly;
        this.currentState = InternalState.INITIAL;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Estado de abertura de arquivo. Somente leitura? " + readOnly);
        }
    }

    public boolean read(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.fileIdSize = buffer.get();
                buffer.clear();
                this.currentState = InternalState.IDENTIFIER_SIZE_RECEIVED;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Tamanho do identificador lido " + this.fileIdSize);
                }
            }
            case IDENTIFIER_SIZE_RECEIVED: {
                FileChannelRequestInfo fileChannelInfo;
                buffer.limit(this.fileIdSize);
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.fileId = new byte[this.fileIdSize];
                buffer.get(this.fileId);
                buffer.clear();
                this.currentState = InternalState.IDENTIFIER_RECEIVED;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Identificador lido " + this.fileId);
                }
                if (this.fileId.equals((fileChannelInfo = session.getFileChannelInfo()).getFileId())) {
                    this.errorCode = ErrorCode.NO_PERMISSION;
                    break;
                }
                FileServer fileServer = session.getFileServer();
                try {
                    this.fileChannel = fileServer.createFileChannel(fileChannelInfo.getRequester(), fileChannelInfo.getFileId(), this.readOnly);
                    if (this.fileChannel == null) {
                        this.errorCode = ErrorCode.FILE_NOT_FOUND;
                        break;
                    }
                    this.errorCode = ErrorCode.OK;
                    break;
                }
                catch (FailureException e) {
                    this.errorCode = ErrorCode.FAILURE;
                    break;
                }
                catch (PermissionException e) {
                    this.errorCode = ErrorCode.NO_PERMISSION;
                }
            }
        }
        return true;
    }

    public boolean write(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case IDENTIFIER_RECEIVED: {
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                buffer.put(this.errorCode.getCode());
                buffer.flip();
                try {
                    if (channel.write(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                buffer.clear();
                this.currentState = InternalState.ERROR_CODE_SENT;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("C\u00f3digo " + (Object)((Object)this.errorCode) + " enviado.");
                }
                if (!this.errorCode.equals((Object)ErrorCode.OK)) {
                    return false;
                }
                session.setFileChannel(this.fileChannel);
                session.setCurrentState(new GetOperationState());
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum InternalState {
        INITIAL,
        IDENTIFIER_SIZE_RECEIVED,
        IDENTIFIER_RECEIVED,
        ERROR_CODE_SENT;

    }
}

