/*
 * Decompiled with CFR 0.152.
 */
package scs.core.servant;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import scs.core.ComponentId;
import scs.core.FacetDescription;
import scs.core.IComponentHelper;
import scs.core.IMetaInterfaceHelper;
import scs.core.IReceptaclesHelper;
import scs.core.ReceptacleDescription;
import scs.core.servant.ComponentContext;
import scs.core.servant.ComponentContextImpl;
import scs.core.servant.ExtendedFacetDescription;
import scs.core.servant.IComponentServant;
import scs.core.servant.IMetaInterfaceServant;
import scs.core.servant.IReceptaclesServant;
import scs.core.servant.Receptacle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentBuilder {
    private POA poa;
    private ORB orb;

    public ComponentBuilder(POA pOA, ORB oRB) {
        this.poa = pOA;
        this.orb = oRB;
    }

    private ComponentContext createContext(ComponentId componentId) throws IllegalArgumentException {
        if (componentId == null) {
            throw new IllegalArgumentException("ComponentId null!");
        }
        return new ComponentContextImpl(this, componentId);
    }

    private void testForGetComponent(Class<?> clazz, String string) {
        try {
            clazz.getMethod("_get_component", null);
        }
        catch (Exception exception) {
            System.err.println("_get_component nao foi definida para a classe " + string + "!");
        }
    }

    private void assemble(ComponentContext componentContext, ExtendedFacetDescription[] extendedFacetDescriptionArray, FacetDescription[] facetDescriptionArray, ReceptacleDescription[] receptacleDescriptionArray) throws IllegalArgumentException, ServantNotActive, WrongPolicy, BadKind, SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int n;
        if (extendedFacetDescriptionArray != null) {
            for (n = 0; n < extendedFacetDescriptionArray.length; ++n) {
                componentContext.getExtendedFacetDescs().put(extendedFacetDescriptionArray[n].name, extendedFacetDescriptionArray[n]);
            }
        } else {
            throw new IllegalArgumentException();
        }
        if (facetDescriptionArray != null) {
            for (n = 0; n < facetDescriptionArray.length; ++n) {
                componentContext.getFacetDescs().put(facetDescriptionArray[n].name, facetDescriptionArray[n]);
                componentContext.getFacets().put(facetDescriptionArray[n].name, facetDescriptionArray[n].facet_ref);
            }
        } else {
            this.createFacetDescriptions(componentContext, extendedFacetDescriptionArray);
        }
        if (receptacleDescriptionArray != null) {
            for (n = 0; n < receptacleDescriptionArray.length; ++n) {
                Receptacle receptacle = new Receptacle(receptacleDescriptionArray[n]);
                componentContext.getReceptacles().put(receptacleDescriptionArray[n].name, receptacle);
                componentContext.getReceptacleDescs().put(receptacleDescriptionArray[n].name, receptacleDescriptionArray[n]);
            }
        }
        this.addBasicFacets(componentContext);
    }

    private void createFacetDescriptions(ComponentContext componentContext, ExtendedFacetDescription[] extendedFacetDescriptionArray) throws ClassNotFoundException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ServantNotActive, WrongPolicy {
        if (extendedFacetDescriptionArray != null) {
            for (int i = 0; i < extendedFacetDescriptionArray.length; ++i) {
                ExtendedFacetDescription extendedFacetDescription = extendedFacetDescriptionArray[i];
                Class<?> clazz = Class.forName(extendedFacetDescription.class_name);
                this.testForGetComponent(clazz, extendedFacetDescription.class_name);
                Object obj = clazz.getConstructor(ComponentContext.class).newInstance(componentContext);
                if (!(obj instanceof Servant)) continue;
                this.addFacetDescToComponent(componentContext, extendedFacetDescription, (Servant)obj);
            }
        }
    }

    private void addFacetDescToComponent(ComponentContext componentContext, ExtendedFacetDescription extendedFacetDescription, Servant servant) throws ServantNotActive, WrongPolicy {
        FacetDescription facetDescription = new FacetDescription();
        facetDescription.name = extendedFacetDescription.name;
        facetDescription.interface_name = extendedFacetDescription.interface_name;
        facetDescription.facet_ref = this.poa.servant_to_reference(servant);
        componentContext.getFacetDescs().put(facetDescription.name, facetDescription);
        componentContext.getFacets().put(extendedFacetDescription.name, servant);
    }

    private void addBasicFacets(ComponentContext componentContext) throws ServantNotActive, WrongPolicy, BadKind {
        Object object;
        Object object2;
        Object object3;
        String string = IComponentHelper.type().name();
        if (!componentContext.getFacetDescs().containsKey(string)) {
            object3 = new IComponentServant(componentContext);
            object2 = new ExtendedFacetDescription(string, IComponentHelper.id(), IComponentServant.class.getSimpleName());
            this.addFacetDescToComponent(componentContext, (ExtendedFacetDescription)object2, (Servant)object3);
            componentContext.getExtendedFacetDescs().put(((ExtendedFacetDescription)object2).name, (ExtendedFacetDescription)object2);
        }
        object3 = IReceptaclesHelper.type().name();
        if (!componentContext.getFacetDescs().containsKey(object3)) {
            object2 = new IReceptaclesServant(componentContext);
            object = new ExtendedFacetDescription((String)object3, IReceptaclesHelper.id(), IReceptaclesServant.class.getSimpleName());
            this.addFacetDescToComponent(componentContext, (ExtendedFacetDescription)object, (Servant)object2);
            componentContext.getExtendedFacetDescs().put(object.name, (ExtendedFacetDescription)object);
        }
        object2 = IMetaInterfaceHelper.type().name();
        if (!componentContext.getFacetDescs().containsKey(object2)) {
            object = new IMetaInterfaceServant(componentContext);
            ExtendedFacetDescription extendedFacetDescription = new ExtendedFacetDescription((String)object2, IMetaInterfaceHelper.id(), IMetaInterfaceServant.class.getSimpleName());
            this.addFacetDescToComponent(componentContext, extendedFacetDescription, (Servant)object);
            componentContext.getExtendedFacetDescs().put(extendedFacetDescription.name, extendedFacetDescription);
        }
    }

    public ComponentContext newComponent(ExtendedFacetDescription[] extendedFacetDescriptionArray, ComponentId componentId) throws ServantNotActive, WrongPolicy, InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException, BadKind {
        return this.newComponent(extendedFacetDescriptionArray, null, componentId, null);
    }

    public ComponentContext newComponent(ExtendedFacetDescription[] extendedFacetDescriptionArray, ReceptacleDescription[] receptacleDescriptionArray, ComponentId componentId) throws ServantNotActive, WrongPolicy, InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException, BadKind {
        return this.newComponent(extendedFacetDescriptionArray, receptacleDescriptionArray, componentId, null);
    }

    public ComponentContext newComponent(ExtendedFacetDescription[] extendedFacetDescriptionArray, ReceptacleDescription[] receptacleDescriptionArray, ComponentId componentId, ComponentContext componentContext) throws ServantNotActive, WrongPolicy, InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException, BadKind {
        if (componentContext == null) {
            componentContext = this.createContext(componentId);
        }
        this.assemble(componentContext, extendedFacetDescriptionArray, null, receptacleDescriptionArray);
        return componentContext;
    }

    public ComponentContext newComponent(FacetDescription[] facetDescriptionArray, ReceptacleDescription[] receptacleDescriptionArray, ComponentId componentId, ComponentContext componentContext) throws ServantNotActive, WrongPolicy, BadKind, IllegalArgumentException, SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (componentContext == null) {
            componentContext = this.createContext(componentId);
        }
        ExtendedFacetDescription[] extendedFacetDescriptionArray = new ExtendedFacetDescription[facetDescriptionArray.length];
        for (int i = 0; i < facetDescriptionArray.length; ++i) {
            ExtendedFacetDescription extendedFacetDescription;
            FacetDescription facetDescription = facetDescriptionArray[i];
            String string = facetDescription.facet_ref.getClass().getCanonicalName();
            extendedFacetDescriptionArray[i] = extendedFacetDescription = new ExtendedFacetDescription(facetDescription.name, facetDescription.interface_name, string);
        }
        this.assemble(componentContext, extendedFacetDescriptionArray, facetDescriptionArray, receptacleDescriptionArray);
        return componentContext;
    }

    public Map<String, String> deactivateComponent(ComponentContext componentContext) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (FacetDescription facetDescription : componentContext.getFacetDescs().values()) {
            try {
                this.poa.deactivate_object(this.poa.reference_to_id(facetDescription.facet_ref));
                facetDescription.facet_ref = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                hashMap.put(facetDescription.name, exception.getMessage());
            }
        }
        return hashMap;
    }

    public static String componentIdToString(ComponentId componentId) {
        return componentId.name + String.valueOf(componentId.major_version) + String.valueOf(componentId.minor_version) + String.valueOf(componentId.patch_version);
    }

    public POA getPOA() {
        return this.poa;
    }

    public ORB getORB() {
        return this.orb;
    }
}

