/*
 * Decompiled with CFR 0.152.
 */
package openbus.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import openbus.util.BusInfo;
import openbus.util.OpenBusProperties;
import openbus.util.OpenBusProxyException;
import openbusidl.acs.Credential;
import openbusidl.rs.IRegistryService;
import openbusidl.rs.Property;
import openbusidl.rs.ServiceOffer;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.ORB;
import scs.core.ComponentId;
import scs.core.IComponent;
import scs.core.IComponentHelper;
import scs.core.servant.ComponentBuilder;
import scs.core.servant.ComponentContext;
import scs.core.servant.ExtendedFacetDescription;
import tecgraf.openbus.Openbus;
import tecgraf.openbus.lease.LeaseExpiredCallback;
import tecgraf.openbus.util.CryptoUtils;
import tecgraf.openbus.util.Log;

public class OpenBusProxy {
    private Map<String, IComponent> components;
    private OpenBusProperties properties = null;
    private static InputStream privateKeyStream;
    private static InputStream acsCertificateStream;
    private static OpenbusConnectionManager acsFetcher;
    private static ORBThread orbThread;
    private boolean isOpen = false;
    private static int numberOfOpenProxies;

    public OpenBusProxy() throws OpenBusProxyException {
        this(new OpenBusProperties());
    }

    public OpenBusProxy(InputStream propertiesFile) throws OpenBusProxyException {
        this(new OpenBusProperties(propertiesFile));
    }

    public OpenBusProxy(String fileName) throws OpenBusProxyException {
        this(new OpenBusProperties(fileName));
    }

    public OpenBusProxy(Properties properties) throws OpenBusProxyException {
        this(new OpenBusProperties(properties));
    }

    private OpenBusProxy(OpenBusProperties properties) throws OpenBusProxyException {
        this.properties = properties;
        OpenBusProxy.setLogLevel(properties.getLogLevel());
        this.components = new Hashtable<String, IComponent>();
    }

    public void setPrivatekey(InputStream privateKeyStream) {
        OpenBusProxy.privateKeyStream = privateKeyStream;
    }

    public void setACSCertificate(InputStream acsCertificateStream) {
        OpenBusProxy.acsCertificateStream = acsCertificateStream;
    }

    public OpenBusProperties getProperties() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws OpenBusProxyException {
        if (this.isOpen) {
            return;
        }
        if (!this.properties.isOpenBusEnabled()) {
            throw new OpenBusProxyException("A conex\u00e3o com o openbus n\u00e3o est\u00e1 habilitada. Verifique o valor da propriedade " + OpenBusProperties.ENABLED_PROPERTY);
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (numberOfOpenProxies == 0) {
                acsFetcher = new OpenbusConnectionManager(this.properties);
                orbThread = new ORBThread();
                orbThread.start();
                acsFetcher.start();
            } else {
                OpenBusProperties currentProperties = acsFetcher.properties;
                if (!currentProperties.getHost().equals(this.properties.getHost()) || currentProperties.getPort() != this.properties.getPort()) {
                    throw new OpenBusProxyException("Tentativa de abrir uma conex\u00e3o com o OpenBus na m\u00e1quina " + this.properties.getHost() + " na porta " + this.properties.getPort() + ". J\u00e1 existe uma conex\u00e3o estabelecida com o barramento " + "na m\u00e1quina " + currentProperties.getHost() + " na porta " + currentProperties.getPort());
                }
                if (!currentProperties.getCertificate().equals(this.properties.getCertificate())) {
                    throw new OpenBusProxyException("Tentativa de abrir uma conex\u00e3o com o OpenBus usando o certificado " + this.properties.getCertificate() + ". J\u00e1 existe uma conex\u00e3o estabelecida com o barramento " + "usando o certificado " + currentProperties.getCertificate());
                }
            }
            ++numberOfOpenProxies;
        }
        this.isOpen = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(String user, String password) throws OpenBusProxyException {
        if (!this.properties.isOpenBusEnabled()) {
            throw new OpenBusProxyException("A conex\u00e3o com o openbus n\u00e3o est\u00e1 habilitada. Verifique o valor da propriedade " + OpenBusProperties.ENABLED_PROPERTY);
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (numberOfOpenProxies == 0) {
                acsFetcher = new OpenbusConnectionManager(this.properties, user, password);
                orbThread = new ORBThread();
                orbThread.start();
                acsFetcher.start();
            } else {
                OpenBusProperties currentProperties = acsFetcher.properties;
                if (!currentProperties.getHost().equals(this.properties.getHost()) || currentProperties.getPort() != this.properties.getPort()) {
                    throw new OpenBusProxyException("Tentativa de abrir uma conex\u00e3o com o OpenBus na m\u00e1quina " + this.properties.getHost() + " na porta " + this.properties.getPort() + ". J\u00e1 existe uma conex\u00e3o estabelecida com o barramento " + "na m\u00e1quina " + currentProperties.getHost() + " na porta " + currentProperties.getPort());
                }
                if (!acsFetcher.user.equals(user)) {
                    throw new OpenBusProxyException("Tentativa de abrir uma conex\u00e3o com o OpenBus usando o login " + user + ". J\u00e1 existe uma conex\u00e3o estabelecida com o barramento " + "usando o login " + acsFetcher.user);
                }
            }
            ++numberOfOpenProxies;
        }
        this.isOpen = true;
    }

    public static void setLogLevel(Level newLevel) {
        Log.setLogsLevel((Level)newLevel);
    }

    public static void setLogHandler(Logger logger) {
        for (Handler handler : logger.getHandlers()) {
            Log.SERVICES.addHandler(handler);
        }
    }

    public String getRequesterUserId() {
        Openbus bus = Openbus.getInstance();
        Credential credential = bus.getInterceptedCredential();
        if (credential == null || credential.identifier.trim().equals("")) {
            return null;
        }
        if (!credential.delegate.equals("")) {
            return credential.delegate;
        }
        return credential.owner;
    }

    public String getRequesterSystemId() {
        Openbus bus = Openbus.getInstance();
        Credential credential = bus.getInterceptedCredential();
        if (credential == null || credential.identifier.trim().equals("")) {
            return null;
        }
        return credential.owner;
    }

    public IComponent getComponent(String name) throws OpenBusProxyException {
        if (!this.components.containsKey(name)) {
            String componentId = this.getComponentId(this.properties.getComponentName(name).trim(), this.properties.getComponentVersion(name).trim());
            IComponent component = acsFetcher.getComponent(name, componentId);
            this.components.put(name, component);
        }
        return this.components.get(name);
    }

    public void registerFactory(String helperId, ValueFactory factory) {
        Openbus bus = Openbus.getInstance();
        ORB orb = (ORB)bus.getORB();
        orb.register_value_factory(helperId, factory);
    }

    private String getComponentId(String componentName, String componentVersion) {
        String[] tmp = componentVersion.split("[\\.]");
        StringBuffer componentId = new StringBuffer(componentName);
        componentId.append(':');
        for (String s : tmp) {
            componentId.append(s.trim());
        }
        return componentId.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.isOpen) {
            return;
        }
        this.isOpen = false;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (acsFetcher != null && --numberOfOpenProxies == 0) {
                acsFetcher.finish();
                acsFetcher = null;
            }
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean isEnabled() {
        return this.properties.isOpenBusEnabled();
    }

    public boolean isActive() {
        if (acsFetcher != null && acsFetcher.isRunning()) {
            return false;
        }
        return Openbus.getInstance().isConnected();
    }

    public boolean addComponent(ServiceOffer serviceOffer) throws OpenBusProxyException {
        if (!this.isEnabled()) {
            throw new OpenBusProxyException("O proxy n\u00e3o est\u00e1 habilitado para publica\u00e7\u00e3o desse componente");
        }
        if (!this.isOpen()) {
            throw new OpenBusProxyException("O proxy n\u00e3o est\u00e1 aberto");
        }
        ComponentEntry entry = new ComponentEntry(serviceOffer);
        boolean success = acsFetcher.register(entry);
        if (success) {
            acsFetcher.addComponentToRegister(entry);
        }
        return success;
    }

    public boolean addComponent(String name, String interfaceName, String className) throws OpenBusProxyException {
        ComponentContext context;
        if (!this.isOpen()) {
            throw new OpenBusProxyException("O proxy n\u00e3o est\u00e1 aberto");
        }
        if (!this.isEnabled()) {
            throw new OpenBusProxyException("O proxy n\u00e3o est\u00e1 habilitado para publica\u00e7\u00e3o desse componente");
        }
        Openbus bus = Openbus.getInstance();
        ComponentBuilder builder = new ComponentBuilder(bus.getRootPOA(), bus.getORB());
        ExtendedFacetDescription[] descriptions = new ExtendedFacetDescription[]{new ExtendedFacetDescription(name, interfaceName, className)};
        String componentName = this.properties.getComponentName(name);
        String componentVersion = this.properties.getComponentVersion(name);
        String[] tmp = componentVersion.split("[\\.]");
        byte major = Byte.parseByte(tmp[0]);
        byte minor = tmp.length >= 2 ? Byte.parseByte(tmp[1]) : (byte)0;
        byte patch = tmp.length >= 3 ? Byte.parseByte(tmp[2]) : (byte)0;
        Log.SERVICES.info("Oferta de Componente : nome=" + componentName + " vers\u00e3o=" + componentVersion);
        try {
            context = builder.newComponent(descriptions, null, new ComponentId(componentName, major, minor, patch, "Java"));
        }
        catch (Exception e) {
            throw new OpenBusProxyException("Erro ao criar o contexto do componente " + name, e);
        }
        Object obj = context.getIComponent();
        IComponent component = IComponentHelper.narrow((Object)obj);
        return this.addComponent(new ServiceOffer(new Property[0], component));
    }

    public BusInfo getBusInfo() throws OpenBusProxyException {
        if (!this.isOpen()) {
            throw new OpenBusProxyException("O proxy n\u00e3o est\u00e1 aberto");
        }
        return acsFetcher.getBusInfo();
    }

    public void setThreadDelegate(String delegate) {
        if (delegate == null || delegate.trim().equals("")) {
            Openbus.getInstance().setThreadCredential(null);
        } else {
            Credential credential = Openbus.getInstance().getCredential();
            Credential newCredential = new Credential(credential.identifier, credential.owner, delegate);
            Openbus.getInstance().setThreadCredential(newCredential);
        }
    }

    public Credential getCredential() {
        return Openbus.getInstance().getCredential();
    }

    static {
        numberOfOpenProxies = 0;
    }

    private static class ORBThread
    extends Thread {
        private org.omg.CORBA.ORB orb = Openbus.getInstance().getORB();

        ORBThread() {
        }

        public void run() {
            this.orb.run();
        }
    }

    private class ComponentEntry {
        ServiceOffer serviceOffer;
        String registryIdentifier;

        ComponentEntry(ServiceOffer serviceOffer) {
            this.serviceOffer = serviceOffer;
        }
    }

    private static class OpenbusConnectionManager
    extends Thread {
        private OpenBusProperties properties;
        private boolean connectionByLogin = false;
        private String entityName;
        private RSAPrivateKey privateKey;
        private X509Certificate acsCertificate;
        private String user;
        private LeaseExpiredCallbackImpl leaseExpiredCallback;
        private IRegistryService registryService;
        private BusInfo busInfo;
        private volatile boolean mustContinue;
        private volatile boolean invalid = false;
        private Set<ComponentEntry> componentsToRegister;

        OpenbusConnectionManager(OpenBusProperties properties) throws OpenBusProxyException {
            this.init(properties);
            try {
                this.privateKey = privateKeyStream == null ? CryptoUtils.readPrivateKey((String)properties.getPrivateKey()) : CryptoUtils.readPrivateKey((InputStream)privateKeyStream);
            }
            catch (GeneralSecurityException e) {
                throw new OpenBusProxyException("Erro na inicializa\u00e7\u00e3o do proxy", e);
            }
            catch (IOException e) {
                throw new OpenBusProxyException("Erro na inicializa\u00e7\u00e3o do proxy", e);
            }
            try {
                this.acsCertificate = acsCertificateStream == null ? CryptoUtils.readCertificate((String)properties.getCertificate()) : CryptoUtils.readCertificate((InputStream)acsCertificateStream);
            }
            catch (CertificateException e) {
                throw new OpenBusProxyException("Erro na inicializa\u00e7\u00e3o do proxy", e);
            }
            catch (FileNotFoundException e) {
                throw new OpenBusProxyException("Erro na inicializa\u00e7\u00e3o do proxy", e);
            }
            this.connectByCertificate();
            this.connectionByLogin = false;
        }

        OpenbusConnectionManager(OpenBusProperties properties, String user, String password) throws OpenBusProxyException {
            this.init(properties);
            this.user = user;
            this.connectByLogin(password);
            this.connectionByLogin = true;
        }

        private void init(OpenBusProperties properties) {
            this.properties = properties;
            this.componentsToRegister = new HashSet<ComponentEntry>();
            this.leaseExpiredCallback = new LeaseExpiredCallbackImpl();
            this.entityName = properties.getEntityName();
            this.busInfo = new BusInfo(properties.getHost(), properties.getPort());
        }

        private Openbus getBus() throws OpenBusProxyException {
            if (this.properties == null) {
                throw new OpenBusProxyException("Propriedades n\u00e3o definidas");
            }
            Log.setLogsLevel((Level)Level.WARNING);
            Properties orbProps = new Properties();
            orbProps.setProperty("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
            orbProps.setProperty("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
            Openbus bus = Openbus.getInstance();
            try {
                bus.resetAndInitialize(new String[0], orbProps, this.properties.getHost(), this.properties.getPort());
            }
            catch (UserException e) {
                throw new OpenBusProxyException("Erro no acesso ao OpenBus (getBus()): " + this.properties.getHost() + " " + this.properties.getPort(), e);
            }
            return bus;
        }

        private void connectByLogin(String password) throws OpenBusProxyException {
            try {
                Openbus bus = this.getBus();
                this.registryService = bus.connect(this.user, password);
            }
            catch (Exception e) {
                throw new OpenBusProxyException("Erro no acesso ao OpenBus: host: " + this.properties.getHost() + " port: " + this.properties.getPort() + " usu\u00e1rio: " + this.user, e);
            }
        }

        private void connectByCertificate() throws OpenBusProxyException {
            Openbus bus = this.getBus();
            try {
                this.registryService = bus.connect(this.entityName, this.privateKey, this.acsCertificate);
            }
            catch (Exception e) {
                throw new OpenBusProxyException("Erro na recupera\u00e7\u00e3o do servi\u00e7o de registro: " + this.properties.getHost() + " " + this.properties.getPort(), e);
            }
            if (this.properties.hasDelegation()) {
                String delegateToUser;
                bus.getCredential().delegate = delegateToUser = this.properties.getDelegate();
            }
        }

        public void run() {
            this.mustContinue = true;
            while (this.mustContinue) {
                Openbus bus = Openbus.getInstance();
                try {
                    if (!bus.isConnected()) {
                        if (this.connectionByLogin) {
                            this.connectByLogin("password");
                        } else {
                            this.connectByCertificate();
                        }
                    }
                    bus.addLeaseExpiredCallback((LeaseExpiredCallback)this.leaseExpiredCallback);
                    this.registerComponents();
                    this.mustContinue = false;
                }
                catch (OpenBusProxyException e) {
                    Log.SERVICES.severe(e.getMessage(), (Throwable)e);
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException ie) {
                    }
                }
                catch (SystemException e) {
                    Log.SERVICES.severe(e.getMessage(), (Throwable)e);
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        boolean registerComponents() {
            for (ComponentEntry component : this.componentsToRegister) {
                try {
                    this.register(component);
                }
                catch (OpenBusProxyException e) {
                    Log.SERVICES.severe(e.getMessage(), (Throwable)e);
                }
            }
            return true;
        }

        boolean register(ComponentEntry component) throws OpenBusProxyException {
            StringHolder identifier = new StringHolder();
            try {
                if (this.registryService.register(component.serviceOffer, identifier)) {
                    component.registryIdentifier = identifier.value;
                    return true;
                }
                return false;
            }
            catch (SystemException e) {
                throw new OpenBusProxyException("Erro no registro do componente " + component.registryIdentifier, e);
            }
        }

        void addComponentToRegister(ComponentEntry component) {
            this.componentsToRegister.add(component);
        }

        private boolean unregisterComponents() {
            boolean success = true;
            for (ComponentEntry component : this.componentsToRegister) {
                try {
                    success &= this.registryService.unregister(component.registryIdentifier);
                }
                catch (SystemException e) {
                    Log.SERVICES.warning(e.getMessage());
                }
            }
            return success;
        }

        void finish() {
            this.mustContinue = false;
            this.invalid = true;
            try {
                this.interrupt();
                this.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                Openbus bus = Openbus.getInstance();
                bus.removeLeaseExpiredCallback();
                this.unregisterComponents();
                bus.disconnect();
            }
            catch (SystemException se) {
                Log.SERVICES.severe("Erro inesperado ao acessar um componente CORBA.", (Throwable)se);
            }
        }

        BusInfo getBusInfo() {
            return this.busInfo;
        }

        boolean isRunning() {
            return this.mustContinue;
        }

        boolean isInvalid() {
            return this.invalid;
        }

        IComponent getComponent(String componentName, String componentId) throws OpenBusProxyException {
            Property property = new Property("component_id", new String[]{componentId});
            ServiceOffer[] servicesOffers = this.registryService.findByCriteria(new String[]{componentName}, new Property[]{property});
            if (servicesOffers.length == 0) {
                throw new OpenBusProxyException("N\u00e3o foi encontrado um servi\u00e7o com identificador: " + componentId);
            }
            if (servicesOffers.length > 1) {
                throw new OpenBusProxyException("Foi encontrado mais de um servi\u00e7o com identificador: " + componentId);
            }
            ServiceOffer serviceOffer = servicesOffers[0];
            return serviceOffer.member;
        }

        private class LeaseExpiredCallbackImpl
        implements LeaseExpiredCallback {
            LeaseExpiredCallbackImpl() {
            }

            public void expired() {
                if (!OpenbusConnectionManager.this.isRunning() && !OpenbusConnectionManager.this.isInvalid()) {
                    OpenbusConnectionManager.this.start();
                }
            }
        }
    }
}

