/*
 * Decompiled with CFR 0.152.
 */
package openbus.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import openbus.util.OpenBusProxyException;

public class OpenBusProperties
extends Properties {
    public static String DEFAULT_PROPERTIES_FILE = "openbus.properties";
    public static String ENABLED_PROPERTY = "openbus.enabled";
    public static String HOST_PROPERTY = "openbus.acs.host";
    public static String PORT_PROPERTY = "openbus.acs.port";
    public static String DELEGATE_PROPERTY = "openbus.acs.delegate";
    public static String ENTITY_PROPERTY = "openbus.acs.entity.name";
    public static String PRIVATE_KEY_PROPERTY = "openbus.acs.private.key";
    public static String CERTIFICATE_PROPERTY = "openbus.acs.certificate";
    public static String LOG_LEVEL_PROPERTY = "openbus.log.level";
    public static String COMPONENT_ENABLED = ".component.enabled";
    public static String COMPONENT_NAME_PROPERTY = ".component.name";
    public static String COMPONENT_VERSION_PROPERTY = ".component.version";
    public static String DEFAULT_HOST = "localhost";
    public static int DEFAULT_PORT = 3000;
    public static final Level DEFAULT_LOG_LEVEL = Level.FINEST;

    public OpenBusProperties() throws OpenBusProxyException {
        try {
            this.load(new FileInputStream(DEFAULT_PROPERTIES_FILE));
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            throw new OpenBusProxyException("Erro na leitura do arquivo de propriedades " + DEFAULT_PROPERTIES_FILE, e);
        }
    }

    public OpenBusProperties(String fileName) throws OpenBusProxyException {
        try {
            this.load(new FileInputStream(fileName));
        }
        catch (FileNotFoundException e) {
            throw new OpenBusProxyException("Erro na leitura do arquivo de propriedades " + fileName, e);
        }
        catch (IOException e) {
            throw new OpenBusProxyException("Erro na leitura do arquivo de propriedades " + fileName, e);
        }
    }

    public OpenBusProperties(Properties properties) {
        this.putAll((Map<?, ?>)properties);
    }

    public OpenBusProperties(InputStream propertiesFile) throws OpenBusProxyException {
        try {
            this.load(propertiesFile);
        }
        catch (IOException e) {
            throw new OpenBusProxyException("Erro na leitura do arquivo de propriedades " + propertiesFile, e);
        }
    }

    public boolean isOpenBusEnabled() {
        String property = this.getProperty(ENABLED_PROPERTY);
        if (property == null || property.trim().equals("")) {
            return false;
        }
        return Boolean.parseBoolean(property);
    }

    public void setOpenBusEnabled(boolean enabled) {
        this.put(ENABLED_PROPERTY, Boolean.toString(enabled));
    }

    public String getHost() {
        String property = this.getProperty(HOST_PROPERTY);
        if (property == null || property.trim().equals("")) {
            return DEFAULT_HOST;
        }
        return property;
    }

    public void setHost(String name) {
        this.put(HOST_PROPERTY, name);
    }

    public int getPort() {
        String property = this.getProperty(PORT_PROPERTY);
        if (property == null || property.trim().equals("")) {
            return DEFAULT_PORT;
        }
        return Integer.parseInt(property);
    }

    public void setPort(int port) {
        this.put(PORT_PROPERTY, (Object)port);
    }

    public String getDelegate() {
        return this.getProperty(DELEGATE_PROPERTY);
    }

    public void setDelegate(String login) {
        this.put(DELEGATE_PROPERTY, login);
    }

    public String getEntityName() {
        return this.getProperty(ENTITY_PROPERTY);
    }

    public void setEntityName(String entityName) {
        this.put(ENTITY_PROPERTY, entityName);
    }

    public String getPrivateKey() {
        return this.getProperty(PRIVATE_KEY_PROPERTY);
    }

    public void setPrivateKey(String privateKey) {
        this.put(PRIVATE_KEY_PROPERTY, privateKey);
    }

    public String getCertificate() {
        return this.getProperty(CERTIFICATE_PROPERTY);
    }

    public void setCertificate(String certificate) {
        this.put(CERTIFICATE_PROPERTY, certificate);
    }

    public boolean hasDelegation() {
        String value = this.getDelegate();
        return value != null && !value.trim().equals("");
    }

    public String getUser() {
        if (this.hasDelegation()) {
            return this.getDelegate();
        }
        return this.getEntityName();
    }

    public String getComponentName(String key) throws OpenBusProxyException {
        String propertyName = key + COMPONENT_NAME_PROPERTY;
        String property = this.getProperty(propertyName);
        if (property == null || property.trim().equals("")) {
            throw new OpenBusProxyException("A propriedade " + propertyName + " n\u00e3o est\u00e1 definida.");
        }
        return property;
    }

    public String getComponentVersion(String key) throws OpenBusProxyException {
        String propertyName = key + COMPONENT_VERSION_PROPERTY;
        String property = this.getProperty(propertyName);
        if (property == null || property.trim().equals("")) {
            throw new OpenBusProxyException("A propriedade " + propertyName + " n\u00e3o est\u00e1 definida.");
        }
        return property;
    }

    public boolean mayExportComponent(String key) {
        String propertyName = key + COMPONENT_ENABLED;
        String property = this.getProperty(propertyName);
        if (property == null || property.trim().equals("")) {
            return true;
        }
        return Boolean.parseBoolean(property);
    }

    public Level getLogLevel() {
        String property = this.getProperty(LOG_LEVEL_PROPERTY);
        if (property == null || property.trim().equals("")) {
            return DEFAULT_LOG_LEVEL;
        }
        return Level.parse(property);
    }

    public void setLogLevel(Level level) {
        this.put(LOG_LEVEL_PROPERTY, level.getLocalizedName());
    }
}

