/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.data_service;

import openbusidl.rs.IRegistryService;
import openbusidl.rs.Property;
import openbusidl.rs.ServiceOffer;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import scs.core.ComponentId;
import scs.core.IComponent;
import scs.core.IComponentHelper;
import tecgraf.openbus.Openbus;
import tecgraf.openbus.data_service.DataKey;
import tecgraf.openbus.data_service.DataServiceUnavailableException;

public final class DataServiceFinder {
    public static IComponent find(DataKey dataKey) throws DataServiceUnavailableException {
        ServiceOffer[] serviceOffer;
        ORB orb;
        Object obj;
        ServiceOffer[] component;
        Openbus bus = Openbus.getInstance();
        String serviceFacetIOR = dataKey.getServiceFacetIOR();
        if (serviceFacetIOR != null && (component = IComponentHelper.narrow((Object)(obj = (orb = bus.getORB()).string_to_object(serviceFacetIOR)))) != null && DataServiceFinder.isReachable((IComponent)component)) {
            return component;
        }
        IRegistryService registryService = bus.getRegistryService();
        String[] facets = new String[]{dataKey.getServiceFacetName()};
        ComponentId componentId = dataKey.getServiceComponentId();
        if (componentId != null) {
            String componentIdString = componentId.name + ":";
            componentIdString = componentIdString + componentId.major_version;
            componentIdString = componentIdString + componentId.minor_version;
            componentIdString = componentIdString + componentId.patch_version;
            Property property = new Property("component_id", new String[]{componentIdString});
            component = registryService.findByCriteria(facets, new Property[]{property});
        }
        if ((serviceOffer = registryService.find(facets)).length < 1) {
            throw new DataServiceUnavailableException();
        }
        return serviceOffer[0].member;
    }

    private static boolean isReachable(IComponent component) {
        try {
            component.getComponentId();
            return true;
        }
        catch (SystemException e) {
            return false;
        }
    }
}

