/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.interceptors;

import java.lang.reflect.Method;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import tecgraf.openbus.Openbus;
import tecgraf.openbus.access_control_service.CredentialWrapper;
import tecgraf.openbus.core.v1_05.access_control_service.Credential;
import tecgraf.openbus.core.v1_05.access_control_service.CredentialHelper;
import tecgraf.openbus.interceptors.InterceptorImpl;
import tecgraf.openbus.util.Log;

class ClientInterceptor
extends InterceptorImpl
implements ClientRequestInterceptor {
    ClientInterceptor(Codec codec) {
        super("ClientInterceptor", codec);
    }

    public void send_request(ClientRequestInfo ri) {
        Log.INTERCEPTORS.info("Opera\u00e7\u00e3o {" + ri.operation() + "} interceptada no cliente.");
        for (Method op : Object.class.getMethods()) {
            if (!ri.operation().equals(op.getName())) continue;
            Log.INTERCEPTORS.fine(String.format("O m\u00e9todo {} pertence a interface {} e n\u00e3o ser\u00e1 interceptado", op.getName(), Object.class.getCanonicalName()));
            return;
        }
        Openbus bus = Openbus.getInstance();
        Credential credential = bus.getCredential();
        if (credential == null || credential.identifier.equals("")) {
            Log.INTERCEPTORS.info("Opera\u00e7\u00e3o {" + ri.operation() + "} SEM CREDENCIAL!");
            return;
        }
        CredentialWrapper wrapper = new CredentialWrapper(credential);
        Log.INTERCEPTORS.info("Opera\u00e7\u00e3o {" + ri.operation() + "} Credencial: " + wrapper);
        byte[] value = null;
        try {
            ORB orb = bus.getORB();
            Any credentialValue = orb.create_any();
            CredentialHelper.insert((Any)credentialValue, (Credential)credential);
            value = this.getCodec().encode_value(credentialValue);
        }
        catch (Exception e) {
            Log.INTERCEPTORS.severe("Opera\u00e7\u00e3o {" + ri.operation() + "} ERRO NA CODIFICA\u00c7\u00c2O DA CREDENCIAL!", e);
            return;
        }
        ri.add_request_service_context(new ServiceContext(1234, value), false);
        Log.INTERCEPTORS.fine("Opera\u00e7\u00e3o {" + ri.operation() + "} INSERI CREDENCIAL!");
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    public void receive_reply(ClientRequestInfo ri) {
    }

    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
    }

    public void receive_other(ClientRequestInfo ri) {
    }
}

