/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc.server.states;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc.common.logic.ErrorCode;
import tecgraf.ftc.common.logic.PrimitiveTypeSize;
import tecgraf.ftc.server.FileChannelRequestInfo;
import tecgraf.ftc.server.Session;
import tecgraf.ftc.server.states.GetOperationState;
import tecgraf.ftc.server.states.State;
import tecgraf.ftc.utils.IOUtils;

public final class WriteState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private long position;
    private long count;
    private long bytesReceived;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");

    public WriteState() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Estado de escrita.");
        }
    }

    public boolean read(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.position = buffer.getLong();
                buffer.clear();
                this.currentState = InternalState.POSITION_READ;
                return true;
            }
            case POSITION_READ: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.count = buffer.getLong();
                buffer.clear();
                this.currentState = InternalState.BYTE_COUNT_READ;
                return true;
            }
            case CHECKED: {
                long bytesRead;
                FileChannel fileChannel = session.getFileChannel();
                FileChannelRequestInfo fileInfo = session.getFileChannelInfo();
                try {
                    if (fileInfo.useTransferTo()) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("Using TransferFrom");
                        }
                        bytesRead = fileChannel.transferFrom(channel, this.position + this.bytesReceived, this.count - this.bytesReceived);
                    } else {
                        bytesRead = IOUtils.transferFromNonBlock(fileChannel, this.position + this.bytesReceived, this.count - this.bytesReceived, channel, buffer);
                    }
                    if (bytesRead > 0L) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    return false;
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Recebidos " + bytesRead);
                }
                this.bytesReceived += bytesRead;
                if (this.bytesReceived != this.count) break;
                this.currentState = InternalState.BYTES_RECEIVED;
                session.setCurrentState(new GetOperationState());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case BYTE_COUNT_READ: {
                FileChannelRequestInfo fileChannelInfo = session.getFileChannelInfo();
                ErrorCode errorCode = session.getFileServer().isLocked(fileChannelInfo.getRequester(), fileChannelInfo.getFileId()) ? ErrorCode.FILE_LOCKED : ErrorCode.OK;
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                buffer.put(errorCode.getCode());
                buffer.flip();
                try {
                    if (channel.write(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    boolean bl = false;
                    return bl;
                }
                finally {
                    buffer.clear();
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("C\u00f3digo " + (Object)((Object)errorCode) + " enviado.");
                }
                if (errorCode.equals((Object)ErrorCode.OK)) {
                    this.currentState = InternalState.CHECKED;
                    break;
                }
                session.setCurrentState(new GetOperationState());
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum InternalState {
        INITIAL,
        CHECKED,
        POSITION_READ,
        BYTE_COUNT_READ,
        BYTES_RECEIVED;

    }
}

