/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc.server.states;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc.common.logic.PrimitiveTypeSize;
import tecgraf.ftc.server.Session;
import tecgraf.ftc.server.states.GetOperationState;
import tecgraf.ftc.server.states.State;

public final class GetPositionState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private long position;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");

    public GetPositionState() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Estado de obten\u00e7\u00e3o de posi\u00e7\u00e3o.");
        }
    }

    public boolean read(Session session) {
        return true;
    }

    public boolean write(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                FileChannel fileChannel = session.getFileChannel();
                try {
                    this.position = fileChannel.position();
                }
                catch (IOException e) {
                    this.position = -1L;
                    e.printStackTrace();
                }
                this.currentState = InternalState.POSITION_READ;
            }
            case POSITION_READ: {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Enviando a posi\u00e7\u00e3o do arquivo " + this.position);
                }
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                buffer.putLong(this.position);
                buffer.flip();
                try {
                    if (channel.write(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                buffer.clear();
                this.currentState = InternalState.POSITION_WRITTEN;
                session.setCurrentState(new GetOperationState());
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum InternalState {
        INITIAL,
        POSITION_READ,
        POSITION_WRITTEN;

    }
}

