/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.FileChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc.common.exception.FailureException;
import tecgraf.ftc.common.exception.InvalidArraySize;
import tecgraf.ftc.common.exception.PermissionException;
import tecgraf.ftc.common.logic.ErrorCode;
import tecgraf.ftc.server.AccessKey;
import tecgraf.ftc.server.FileChannelAccessInfo;
import tecgraf.ftc.server.FileChannelRequestInfo;
import tecgraf.ftc.server.FileServerConfig;
import tecgraf.ftc.server.FileServerOwner;
import tecgraf.ftc.server.LogFormatter;
import tecgraf.ftc.server.Session;
import tecgraf.ftc.server.states.CloseState;
import tecgraf.ftc.server.states.State;

public final class FileServer {
    private FileServerOwner fileServerOwner;
    private boolean wasStopped;
    private Selector selector;
    private Map<AccessKey, FileChannelRequestInfo> channels;
    private FileServerConfig config = null;
    private ServerSocketChannel serverChannel = null;
    private long lastTimeoutCheck = 0L;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    public static final boolean PLATAFORM_HAS_TRANSFERTO_BUG = System.getProperty("os.name").contains("Linux") && System.getProperty("sun.arch.data.model").contains("32") && !System.getProperty("java.version").contains("1.7.0");

    public FileServer(FileServerOwner fileServerOwner) throws IOException {
        this.fileServerOwner = fileServerOwner;
        this.config = fileServerOwner.getConfig();
        logger.setUseParentHandlers(false);
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
        }
        FileHandler logOutputFile = new FileHandler(this.config.getOutputLogFilename(), true);
        logOutputFile.setFormatter(new LogFormatter());
        logger.addHandler(logOutputFile);
        logger.setLevel(this.config.getLoglevel().getLevel());
        this.serverChannel = ServerSocketChannel.open();
        this.serverChannel.configureBlocking(false);
        ServerSocket serverSocket = this.serverChannel.socket();
        serverSocket.bind(new InetSocketAddress(this.config.getHostName(), this.config.getPort()));
        this.selector = Selector.open();
        this.serverChannel.register(this.selector, 16);
        this.channels = new HashMap<AccessKey, FileChannelRequestInfo>();
    }

    public void dispatch() {
        while (!this.wasStopped) {
            block7: {
                try {
                    int selectedKeyCount = this.selector.select(this.config.getSelectTimeout());
                    this.checkTimedOutConnections();
                    if (selectedKeyCount == 0) {
                    }
                    break block7;
                }
                catch (IOException e) {
                    this.exceptionRaised(e);
                }
                continue;
            }
            Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
            while (selectedKeys.hasNext()) {
                SelectionKey key = selectedKeys.next();
                selectedKeys.remove();
                if (key.isValid() && key.isAcceptable()) {
                    this.accept(key);
                }
                if (key.isValid() && key.isReadable()) {
                    this.read(key);
                }
                if (!key.isValid() || !key.isWritable()) continue;
                this.write(key);
            }
        }
        this.shutdownConnections();
    }

    private void checkTimedOutConnections() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTimeoutCheck < this.config.getSelectTimeout()) {
            return;
        }
        this.lastTimeoutCheck = currentTime;
        Set<SelectionKey> keys = this.selector.keys();
        for (SelectionKey key : keys) {
            long test;
            Session session = (Session)key.attachment();
            if (session == null || (test = currentTime - session.getLastActivity()) <= this.config.getClientTimeout()) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Conexao fechada por inatividade.");
            }
            this.stopConnection(key, session);
        }
    }

    private void shutdownConnections() {
        logger.finer("Fechando conexoes.");
        for (SelectionKey key : this.selector.keys()) {
            Session session = (Session)key.attachment();
            this.stopConnection(key, session);
        }
        this.serverChannel = null;
    }

    public void stop() {
        this.wasStopped = true;
    }

    public FileChannelAccessInfo createFileChannelInfo(Object requester, byte[] fileId) throws InvalidArraySize {
        return this.createFileChannelInfo(requester, fileId, null);
    }

    public FileChannelAccessInfo createFileChannelInfo(Object requester, byte[] fileId, byte[] accessKey) throws InvalidArraySize {
        return this.createFileChannelInfo(requester, fileId, null, true);
    }

    public FileChannelAccessInfo createFileChannelInfo(Object requester, byte[] fileId, byte[] accessKey, boolean useTransferTo) throws InvalidArraySize {
        AccessKey key = accessKey != null ? new AccessKey(accessKey) : new AccessKey();
        FileChannelRequestInfo fileChannelIinfo = new FileChannelRequestInfo(requester, fileId);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Criando novo FileChannelInfo: " + fileId.toString());
        }
        fileChannelIinfo.useTransferTo(useTransferTo);
        this.channels.put(key, fileChannelIinfo);
        return new FileChannelAccessInfo(this.config.getHostName(), this.serverChannel.socket().getLocalPort(), key.getBytes(), fileId);
    }

    public FileChannelRequestInfo getFileChannelInfo(AccessKey accessKey) {
        if (this.config.isTestMode()) {
            return this.channels.get(accessKey);
        }
        return this.channels.remove(accessKey);
    }

    public FileChannel createFileChannel(Object requester, byte[] fileId, boolean readOnly) throws PermissionException, FailureException {
        return this.fileServerOwner.createFileChannel(requester, fileId, readOnly);
    }

    public boolean isLocked(Object requester, byte[] fileId) {
        return this.fileServerOwner.isLocked(requester, fileId);
    }

    void fileChannelClosed(Object requester, byte[] fileId) {
        this.fileServerOwner.fileChannelClosed(requester, fileId);
    }

    public void exceptionRaised(Exception e, byte[] fileId) {
        this.fileServerOwner.exceptionRaised(e, fileId);
    }

    public void exceptionRaised(Exception e) {
        this.fileServerOwner.exceptionRaised(e);
    }

    private void accept(SelectionKey key) {
        SocketChannel socketChannel;
        block10: {
            ServerSocketChannel serverChannel = (ServerSocketChannel)key.channel();
            socketChannel = null;
            try {
                while ((socketChannel = serverChannel.accept()) != null) {
                    socketChannel.configureBlocking(false);
                    Session session = new Session(socketChannel, this);
                    session.markLastActivity();
                    socketChannel.register(this.selector, 5, session);
                    int clients = this.selector.keys().size() - 1;
                    if (clients > this.config.getMaxClients()) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("N\u00famero m\u00e1ximo de clientes atingido.");
                        }
                        session.setCurrentState(new CloseState(ErrorCode.MAX_CLIENTS_REACHED));
                        break;
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Cliente conectado:" + socketChannel.socket().getRemoteSocketAddress());
                        logger.fine("Numero de clientes:" + clients);
                    }
                    if (this.config.acceptMaxPossible()) continue;
                    break;
                }
                return;
            }
            catch (IOException e) {
                this.exceptionRaised(e);
            }
            catch (OutOfMemoryError e) {
                if (!logger.isLoggable(Level.WARNING)) break block10;
                logger.warning("N\u00e3o h\u00e1 recursos suficientes. A Conex\u00e3o sera fechada.");
            }
        }
        try {
            if (socketChannel != null) {
                socketChannel.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void read(SelectionKey key) {
        Session session = (Session)key.attachment();
        try {
            State currentState = session.getCurrentState();
            if (currentState == null || !currentState.read(session)) {
                this.stopConnection(key, session);
            }
        }
        catch (Exception e) {
            this.exceptionRaised(e, session.getFileChannelInfo().getFileId());
            this.stopConnection(key, session);
        }
    }

    private void write(SelectionKey key) {
        Session session = (Session)key.attachment();
        try {
            State currentState = session.getCurrentState();
            if (currentState == null || !currentState.write(session)) {
                this.stopConnection(key, session);
            }
        }
        catch (Exception e) {
            this.exceptionRaised(e, session.getFileChannelInfo().getFileId());
            this.stopConnection(key, session);
        }
    }

    private void stopConnection(SelectionKey key, Session session) {
        if (session != null) {
            session.close();
        } else {
            try {
                key.channel().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        key.attach(null);
        key.cancel();
    }

    public FileServerConfig getConfig() {
        return this.config;
    }

    public void setConfig(FileServerConfig config) {
        this.config = config;
    }
}

