/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc.common.logic;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import tecgraf.ftc.common.exception.FailureException;
import tecgraf.ftc.common.exception.FileLockedException;
import tecgraf.ftc.common.exception.MaxClientsReachedException;
import tecgraf.ftc.common.exception.PermissionException;
import tecgraf.ftc.common.logic.ErrorCode;
import tecgraf.ftc.common.logic.Operation;
import tecgraf.ftc.common.logic.PrimitiveTypeSize;
import tecgraf.ftc.common.logic.RemoteFileChannel;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.ftc.utils.ByteBufferUtils;

public final class RemoteFileChannelImpl
implements RemoteFileChannel {
    private String host;
    private int port;
    private byte[] key;
    private byte[] identifier;
    private boolean writable;
    private boolean open;
    private boolean readOnly;
    private SocketChannel channel;
    private ByteBuffer buffer;
    private int bufferSize = 0x100000;

    public RemoteFileChannelImpl(byte[] identifier, boolean writable, String host, int port, byte[] key) {
        this.host = host;
        this.port = port;
        this.key = key;
        this.identifier = identifier;
        this.writable = writable;
    }

    public RemoteFileChannelImpl(RemoteFileChannelInfo info) {
        this.host = info.getHost();
        this.port = info.getPort();
        this.key = info.getKey();
        this.identifier = info.getIdentifier();
        this.writable = info.isWritable();
    }

    public boolean open(boolean readOnly) throws PermissionException, FileNotFoundException, FailureException, MaxClientsReachedException {
        if (!readOnly && !this.writable) {
            throw new PermissionException("O arquivo n\u00e3o pode ser aberto para escrita.");
        }
        try {
            this.channel = SocketChannel.open(new InetSocketAddress(this.host, this.port));
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
        this.buffer = ByteBuffer.allocate(this.bufferSize);
        Operation operation = readOnly ? Operation.OPEN_READ_ONLY : Operation.OPEN_READ_WRITE;
        ErrorCode errorCode = null;
        try {
            ByteBufferUtils.writeBytes(this.buffer, this.channel, this.key);
            errorCode = this.checkReturnCode();
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        if (!ErrorCode.OK.equals((Object)errorCode)) {
            this.release();
            if (errorCode.equals((Object)ErrorCode.INVALID_KEY)) {
                throw new PermissionException("Chave de acesso inv\u00e1lida.");
            }
            if (errorCode.equals((Object)ErrorCode.MAX_CLIENTS_REACHED)) {
                throw new MaxClientsReachedException("N\u00famero m\u00e1ximo de clientes no servidor atingido.");
            }
            if (errorCode.equals((Object)ErrorCode.FAILURE)) {
                throw new FailureException("Falha no servidor ao tentar se autenticar com a chave fornecida.");
            }
            throw new IllegalStateException("C\u00f3digo de erro inv\u00e1lido " + (Object)((Object)errorCode));
        }
        try {
            this.buffer.put(operation.getCode());
            ByteBufferUtils.writeBytes(this.buffer, this.channel, PrimitiveTypeSize.BYTE.getSize(), this.identifier);
            errorCode = this.checkReturnCode();
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        if (!ErrorCode.OK.equals((Object)errorCode)) {
            this.release();
            if (errorCode.equals((Object)ErrorCode.FILE_NOT_FOUND)) {
                throw new FileNotFoundException("O arquivo n\u00e3o existe.");
            }
            if (errorCode.equals((Object)ErrorCode.NO_PERMISSION)) {
                throw new PermissionException("Sem permiss\u00e3o para abrir o arquivo.");
            }
            if (errorCode.equals((Object)ErrorCode.FAILURE)) {
                throw new FailureException("Falha no servidor ao tentar abrir o arquivo.");
            }
            throw new IllegalStateException("C\u00f3digo de erro inv\u00e1lido " + (Object)((Object)errorCode));
        }
        this.open = true;
        this.readOnly = readOnly;
        return true;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() throws FailureException {
        if (this.channel == null) {
            throw new IllegalStateException("N\u00e3o \u00e9 poss\u00edvel fechar um arquivo que n\u00e3o foi aberto.");
        }
        this.open = false;
        ErrorCode errorCode = ErrorCode.FAILURE;
        try {
            ByteBufferUtils.writeByte(this.buffer, this.channel, Operation.CLOSE.getCode());
            errorCode = this.checkReturnCode();
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        this.release();
        if (ErrorCode.FAILURE.equals((Object)errorCode)) {
            throw new FailureException("Falha no fechamento do canal do arquivo.");
        }
    }

    private ErrorCode checkReturnCode() throws IOException {
        byte code = ByteBufferUtils.readByte(this.buffer, this.channel);
        ErrorCode errorCode = ErrorCode.valueOf(code);
        this.buffer.clear();
        return errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.open = false;
            this.buffer = null;
            this.channel = null;
        }
    }

    public void setSize(long size) throws PermissionException, FailureException {
        if (this.readOnly) {
            throw new PermissionException("Arquivo foi aberto somente para a leitura.");
        }
        this.buffer.put(Operation.SET_SIZE.getCode());
        try {
            ByteBufferUtils.writeLong(this.buffer, this.channel, PrimitiveTypeSize.BYTE.getSize(), size);
            ErrorCode errorCode = this.checkReturnCode();
            if (!errorCode.equals((Object)ErrorCode.OK)) {
                throw new FailureException("Falha ao alterar o tamanho do arquivo.");
            }
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
    }

    public long getPosition() {
        try {
            ByteBufferUtils.writeByte(this.buffer, this.channel, Operation.GET_POSITION.getCode());
            return ByteBufferUtils.readLong(this.buffer, this.channel);
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public void setPosition(long position) throws FailureException {
        try {
            this.buffer.put(Operation.SET_POSITION.getCode());
            ByteBufferUtils.writeLong(this.buffer, this.channel, PrimitiveTypeSize.BYTE.getSize(), position);
            ErrorCode errorCode = this.checkReturnCode();
            if (!errorCode.equals((Object)ErrorCode.OK)) {
                throw new FailureException("Falha ao alterar o tamanho do arquivo.");
            }
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
    }

    public long getSize() {
        try {
            ByteBufferUtils.writeByte(this.buffer, this.channel, Operation.GET_SIZE.getCode());
            long size = ByteBufferUtils.readLong(this.buffer, this.channel);
            this.buffer.clear();
            return size;
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public int read(byte[] target) throws FailureException {
        return this.read(target, 0, target.length, 0L);
    }

    public int read(byte[] target, long position) throws FailureException {
        return this.read(target, 0, target.length, position);
    }

    public int read(byte[] target, int offset, int length) throws FailureException {
        return this.read(target, offset, length, 0L);
    }

    public int read(byte[] target, int offset, int length, long position) throws FailureException {
        this.buffer.put(Operation.READ.getCode());
        this.buffer.putLong(position);
        this.buffer.putLong(length);
        this.buffer.flip();
        try {
            this.channel.write(this.buffer);
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
        finally {
            this.buffer.clear();
        }
        ByteBuffer dstBuffer = ByteBuffer.wrap(target, offset, length);
        try {
            int bytesRead = 0;
            while ((bytesRead += this.channel.read(dstBuffer)) < length) {
            }
            return bytesRead;
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
    }

    public int write(byte[] source) throws PermissionException, FailureException, FileLockedException {
        return this.write(source, 0, source.length, 0L);
    }

    public int write(byte[] source, long position) throws PermissionException, FailureException, FileLockedException {
        return this.write(source, 0, source.length, position);
    }

    public int write(byte[] source, int offset, int length) throws PermissionException, FailureException, FileLockedException {
        return this.write(source, offset, length, 0L);
    }

    public int write(byte[] source, int offset, int length, long position) throws PermissionException, FailureException, FileLockedException {
        byte code;
        if (this.readOnly) {
            throw new PermissionException("Arquivo foi aberto somente para a leitura.");
        }
        this.buffer.put(Operation.WRITE.getCode());
        this.buffer.putLong(position);
        try {
            ByteBufferUtils.writeLong(this.buffer, this.channel, PrimitiveTypeSize.BYTE.getSize() + PrimitiveTypeSize.LONG.getSize(), length);
            code = ByteBufferUtils.readByte(this.buffer, this.channel);
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
        ErrorCode errorCode = ErrorCode.valueOf(code);
        if (errorCode.equals((Object)ErrorCode.FILE_LOCKED)) {
            throw new FileLockedException("Arquivo reservado para outro usu\u00e1rio.");
        }
        ByteBuffer dstBuffer = ByteBuffer.wrap(source, offset, length);
        try {
            int bytesWritten = 0;
            while ((bytesWritten += this.channel.write(dstBuffer)) < length) {
            }
            return bytesWritten;
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
    }

    public long transferTo(long position, long count, OutputStream outputStream) throws FailureException {
        long bytesWrittenTotal;
        int bytesRead;
        this.buffer.put(Operation.READ.getCode());
        this.buffer.putLong(position);
        try {
            ByteBufferUtils.writeLong(this.buffer, this.channel, PrimitiveTypeSize.BYTE.getSize() + PrimitiveTypeSize.LONG.getSize(), count);
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
        for (bytesWrittenTotal = 0L; bytesWrittenTotal < count; bytesWrittenTotal += (long)bytesRead) {
            if ((long)this.buffer.capacity() > count - bytesWrittenTotal) {
                this.buffer.limit((int)(count - bytesWrittenTotal));
            }
            this.buffer.clear();
            try {
                bytesRead = this.channel.read(this.buffer);
            }
            catch (IOException e) {
                throw new FailureException(e);
            }
            if (bytesRead == -1) break;
            try {
                outputStream.write(this.buffer.array(), 0, bytesRead);
                continue;
            }
            catch (IOException e) {
                throw new FailureException(e);
            }
        }
        this.buffer.clear();
        return bytesWrittenTotal;
    }

    public long transferTo(long position, long count, RemoteFileChannel target) throws FailureException, PermissionException, FileLockedException {
        long bytesWrittenTotal;
        int bytesRead;
        this.buffer.put(Operation.READ.getCode());
        this.buffer.putLong(position);
        try {
            ByteBufferUtils.writeLong(this.buffer, this.channel, PrimitiveTypeSize.BYTE.getSize() + PrimitiveTypeSize.LONG.getSize(), count);
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
        for (bytesWrittenTotal = 0L; bytesWrittenTotal < count; bytesWrittenTotal += (long)bytesRead) {
            if ((long)this.buffer.capacity() > count - bytesWrittenTotal) {
                this.buffer.limit((int)(count - bytesWrittenTotal));
            }
            try {
                bytesRead = this.channel.read(this.buffer);
            }
            catch (IOException e) {
                throw new FailureException(e);
            }
            finally {
                this.buffer.clear();
            }
            if (bytesRead == -1) break;
            target.write(this.buffer.array(), 0, bytesRead);
        }
        return bytesWrittenTotal;
    }

    public long transferFrom(InputStream source, long position, long count) throws PermissionException, FailureException, FileLockedException {
        byte code;
        if (this.readOnly) {
            throw new PermissionException("Arquivo foi aberto somente para a leitura.");
        }
        this.buffer.put(Operation.WRITE.getCode());
        this.buffer.putLong(position);
        try {
            ByteBufferUtils.writeLong(this.buffer, this.channel, PrimitiveTypeSize.BYTE.getSize() + PrimitiveTypeSize.LONG.getSize(), count);
            code = ByteBufferUtils.readByte(this.buffer, this.channel);
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
        ErrorCode errorCode = ErrorCode.valueOf(code);
        if (errorCode.equals((Object)ErrorCode.FILE_LOCKED)) {
            throw new FileLockedException("Arquivo reservado para outro usu\u00e1rio.");
        }
        byte[] bufferArray = this.buffer.array();
        long bytesReadTotal = 0L;
        while (bytesReadTotal < count) {
            int bytesRead;
            int len = bufferArray.length;
            if ((long)bufferArray.length > count - bytesReadTotal) {
                len = (int)(count - bytesReadTotal);
            }
            try {
                bytesRead = source.read(bufferArray, 0, len);
            }
            catch (IOException e) {
                throw new FailureException(e);
            }
            if (bytesRead == -1) break;
            bytesReadTotal += (long)bytesRead;
            this.buffer.limit(bytesRead);
            int bytesWrittenTotal = 0;
            while (this.buffer.hasRemaining()) {
                try {
                    int bytesWritten = this.channel.write(this.buffer);
                    if (bytesWritten < 0) {
                        throw new IllegalStateException();
                    }
                    bytesWrittenTotal += bytesWritten;
                }
                catch (IOException e) {
                    this.buffer.clear();
                    throw new FailureException(e);
                }
            }
            this.buffer.clear();
        }
        return bytesReadTotal;
    }

    public long transferFrom(RemoteFileChannel source, long position, long count) throws PermissionException, FailureException, FileLockedException {
        byte code;
        if (this.readOnly) {
            throw new PermissionException("Arquivo foi aberto somente para a leitura.");
        }
        this.buffer.put(Operation.WRITE.getCode());
        this.buffer.putLong(position);
        try {
            ByteBufferUtils.writeLong(this.buffer, this.channel, PrimitiveTypeSize.BYTE.getSize() + PrimitiveTypeSize.LONG.getSize(), count);
            code = ByteBufferUtils.readByte(this.buffer, this.channel);
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
        ErrorCode errorCode = ErrorCode.valueOf(code);
        if (errorCode.equals((Object)ErrorCode.FILE_LOCKED)) {
            throw new FileLockedException("Arquivo reservado para outro usu\u00e1rio.");
        }
        byte[] bufferArray = this.buffer.array();
        long bytesReadTotal = 0L;
        while (bytesReadTotal < count) {
            int len = bufferArray.length;
            if ((long)bufferArray.length > count - bytesReadTotal) {
                len = (int)(count - bytesReadTotal);
            }
            int bytesRead = source.read(bufferArray, 0, len);
            bytesReadTotal += (long)bytesRead;
            this.buffer.limit(bytesRead);
            int bytesWrittenTotal = 0;
            while (this.buffer.hasRemaining()) {
                try {
                    int bytesWritten = this.channel.write(this.buffer);
                    if (bytesWritten < 0) {
                        throw new IllegalStateException();
                    }
                    bytesWrittenTotal += bytesWritten;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.buffer.clear();
                    throw new FailureException(e);
                }
            }
            this.buffer.clear();
        }
        return bytesReadTotal;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }
}

