/*
 * Decompiled with CFR 0.152.
 */
package opendreams.proxy;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import opendreams.proxy.OpenDreamsException;
import tecgraf.ftc.common.exception.FailureException;
import tecgraf.ftc.common.logic.RemoteFileChannelImpl;
import tecgraf.openbus.data_service.DataDescription;
import tecgraf.openbus.data_service.DataKey;
import tecgraf.openbus.data_service.IHierarchicalDataService;
import tecgraf.openbus.data_service.UnstructuredData;
import tecgraf.openbus.data_service.UnstructuredDataHelper;
import tecgraf.openbus.data_service.project.ProjectItemDescriptionImpl;
import tecgraf.openbus.project.ProjectItemDescription;
import tecgraf.openbus.project.ProjectItemDescriptionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project {
    private IHierarchicalDataService dataService;
    private DataDescription projectDesc;
    private String owner;
    private byte[] currentDir;

    Project(DataDescription projectDesc, String owner, IHierarchicalDataService dataService) {
        this.projectDesc = projectDesc;
        this.dataService = dataService;
        this.owner = owner;
        this.currentDir = projectDesc.fKey;
    }

    public boolean changeDirectory(String dirName) throws OpenDreamsException {
        return this.changeDirectory(dirName, false);
    }

    public boolean changeDirectory(String dirName, boolean create) throws OpenDreamsException {
        byte[] fkey = this.find(dirName);
        if (fkey != null) {
            this.currentDir = fkey;
            return true;
        }
        if (create) {
            return this.createDirectory(dirName, true);
        }
        return false;
    }

    public boolean changeDirectoryUp() throws OpenDreamsException {
        try {
            if (this.currentDir.equals(this.projectDesc.fKey)) {
                throw new OpenDreamsException("O diret\u00f3rio corrente \u00e9 o pr\u00f3prio diret\u00f3rio do projeto");
            }
            DataDescription dataDescription = this.dataService.getParent(this.currentDir);
            if (dataDescription == null) {
                throw new OpenDreamsException("O diret\u00f3rio pai retornou null");
            }
            this.currentDir = dataDescription.fKey;
        }
        catch (Exception e) {
            throw new OpenDreamsException("Erro na navega\u00e7\u00e3o para o diret\u00f3rio pai", e);
        }
        return true;
    }

    public boolean createDirectory(String dirName, boolean change) throws OpenDreamsException {
        HashSet<String> views = new HashSet<String>();
        views.add(ProjectItemDescriptionHelper.id());
        long currentDate = Calendar.getInstance().getTimeInMillis();
        ProjectItemDescriptionImpl prototype = new ProjectItemDescriptionImpl(dirName, views, new ArrayList(), this.owner, null, null, null, 0L, true, true, true, currentDate, currentDate);
        try {
            byte[] key = this.dataService.createData(this.currentDir, (DataDescription)prototype);
            if (change) {
                this.currentDir = key;
            }
            return true;
        }
        catch (Exception e) {
            throw new OpenDreamsException("Erro na cria\u00e7\u00e3o do diret\u00f3rio " + dirName + " no projeto " + this.projectDesc.fName, e);
        }
    }

    public boolean createDirectory(String dirName) throws OpenDreamsException {
        return this.createDirectory(dirName, false);
    }

    public byte[] getDataFrom(String fileName) throws OpenDreamsException {
        byte[] fileKey = this.find(fileName);
        if (fileKey == null) {
            throw new OpenDreamsException("Arquivo " + fileName + " n\u00e3o encontrado");
        }
        RemoteFileChannelImpl rfc = null;
        try {
            UnstructuredData view = (UnstructuredData)this.dataService.getDataView(fileKey, UnstructuredDataHelper.id());
            DataKey dataKey = new DataKey(view.fKey);
            rfc = new RemoteFileChannelImpl(dataKey.getDataId().getBytes("UTF8"), view.fWritable, view.fHost, view.fPort, view.fAccessKey);
            rfc.open(true);
            int fileSize = (int)rfc.getSize();
            byte[] buffer = new byte[fileSize];
            if (fileSize != 0) {
                rfc.read(buffer);
            }
            byte[] byArray = buffer;
            return byArray;
        }
        catch (Exception e) {
            throw new OpenDreamsException("Erro na leitura de um dado no projeto", e);
        }
        finally {
            if (rfc != null) {
                try {
                    rfc.close();
                }
                catch (FailureException e) {
                    throw new OpenDreamsException("Erro ao fechar o remote file channel na leitura de um dado no projeto", e);
                }
            }
        }
    }

    public void createFile(String fileName, byte[] data) throws OpenDreamsException {
        byte[] fileKey = this.find(fileName);
        if (fileKey != null) {
            throw new OpenDreamsException("Arquivo " + fileName + " j\u00e1 existe");
        }
        RemoteFileChannelImpl rfc = null;
        try {
            HashSet<String> views = new HashSet<String>();
            views.add(ProjectItemDescriptionHelper.id());
            long currentDate = Calendar.getInstance().getTimeInMillis();
            ProjectItemDescriptionImpl prototype = new ProjectItemDescriptionImpl(fileName, views, new ArrayList(), this.owner, null, null, "UNKNOWN", 0L, false, true, true, currentDate, currentDate);
            fileKey = this.dataService.createData(this.currentDir, (DataDescription)prototype);
            UnstructuredData view = (UnstructuredData)this.dataService.getDataView(fileKey, UnstructuredDataHelper.id());
            DataKey dataKey = new DataKey(view.fKey);
            rfc = new RemoteFileChannelImpl(dataKey.getDataId().getBytes("UTF8"), view.fWritable, view.fHost, view.fPort, view.fAccessKey);
            rfc.open(false);
            rfc.write(data);
        }
        catch (Exception e) {
            throw new OpenDreamsException("Erro na cria\u00e7\u00e3o de um arquivo no projeto", e);
        }
        finally {
            if (rfc != null) {
                try {
                    rfc.close();
                }
                catch (FailureException e) {
                    throw new OpenDreamsException("Erro ao fechar o remote file channel na cria\u00e7\u00e3o de um arquivo no projeto", e);
                }
            }
        }
    }

    public void createFile(String fileName, String type, byte[] data) throws OpenDreamsException {
        byte[] fileKey = this.find(fileName);
        if (fileKey != null) {
            throw new OpenDreamsException("Arquivo " + fileName + " j\u00e1 existe");
        }
        RemoteFileChannelImpl rfc = null;
        try {
            HashSet<String> views = new HashSet<String>();
            views.add(ProjectItemDescriptionHelper.id());
            long currentDate = Calendar.getInstance().getTimeInMillis();
            ProjectItemDescriptionImpl prototype = new ProjectItemDescriptionImpl(fileName, views, new ArrayList(), this.owner, null, null, type, 0L, false, true, true, currentDate, currentDate);
            fileKey = this.dataService.createData(this.currentDir, (DataDescription)prototype);
            UnstructuredData view = (UnstructuredData)this.dataService.getDataView(fileKey, UnstructuredDataHelper.id());
            DataKey dataKey = new DataKey(view.fKey);
            rfc = new RemoteFileChannelImpl(dataKey.getDataId().getBytes("UTF8"), view.fWritable, view.fHost, view.fPort, view.fAccessKey);
            rfc.open(false);
            rfc.write(data);
        }
        catch (Exception e) {
            throw new OpenDreamsException("Erro na cria\u00e7\u00e3o de um arquivo no projeto", e);
        }
        finally {
            if (rfc != null) {
                try {
                    rfc.close();
                }
                catch (FailureException e) {
                    throw new OpenDreamsException("Erro ao fechar o remote file channel na cria\u00e7\u00e3o de um arquivo no projeto", e);
                }
            }
        }
    }

    public void removeFile(String fileName) throws OpenDreamsException {
        byte[] fileKey = this.find(fileName);
        if (fileKey == null) {
            throw new OpenDreamsException("Arquivo " + fileName + " n\u00e3o existe");
        }
        try {
            this.dataService.deleteData(fileKey);
        }
        catch (Exception e) {
            throw new OpenDreamsException("Erro na remo\u00e7\u00e3o do arquivo " + fileName, e);
        }
    }

    public boolean hasFile(String fileName) throws OpenDreamsException {
        try {
            return this.find(fileName) != null;
        }
        catch (Exception e) {
            throw new OpenDreamsException("Erro na consulta se o arquivo " + fileName + " existe", e);
        }
    }

    public String getName() {
        return this.projectDesc.fName;
    }

    private byte[] find(String name) throws OpenDreamsException {
        byte[] fileKey = null;
        try {
            DataDescription[] descriptions;
            for (DataDescription descr : descriptions = this.dataService.getChildren(this.currentDir)) {
                if (!descr.fName.equals(name)) continue;
                fileKey = descr.fKey;
                break;
            }
        }
        catch (Exception e) {
            throw new OpenDreamsException("Erro na procura pelo arquivo ou diret\u00f3rio " + name, e);
        }
        return fileKey;
    }

    public List<String> list() throws OpenDreamsException {
        ArrayList<String> fileNames = new ArrayList<String>();
        try {
            DataDescription[] descriptions;
            for (DataDescription descr : descriptions = this.dataService.getChildren(this.currentDir)) {
                fileNames.add(descr.fName);
            }
        }
        catch (Exception e) {
            throw new OpenDreamsException("Erro na listagem do diret\u00f3rio: " + this.currentDir, e);
        }
        return fileNames;
    }

    public boolean isDirectory(String entryName) throws OpenDreamsException {
        try {
            ProjectItemDescription descr = (ProjectItemDescription)this.dataService.getDataDescription(this.find(entryName));
            return descr.fIsContainer;
        }
        catch (Exception e) {
            throw new OpenDreamsException("Erro ao checar se " + entryName + " \u00e9 diret\u00f3rio.", e);
        }
    }
}

