/*
 * Decompiled with CFR 0.152.
 */
package scs.core.servant;

import java.util.ArrayList;
import java.util.Iterator;
import org.omg.CORBA.Object;
import scs.core.AlreadyConnected;
import scs.core.ConnectionDescription;
import scs.core.ReceptacleDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Receptacle {
    ReceptacleDescription desc;
    ArrayList<ConnectionDescription> connections;

    public Receptacle(ReceptacleDescription desc) {
        this.desc = desc;
        this.connections = new ArrayList();
    }

    public ReceptacleDescription getReceptacleDescription() {
        return this.desc;
    }

    public String getName() {
        return this.desc.name;
    }

    public String getInterfaceName() {
        return this.desc.interface_name;
    }

    public boolean isMultiplex() {
        return this.desc.is_multiplex;
    }

    public ArrayList<ConnectionDescription> getConnections() {
        return this.connections;
    }

    public int getConnectionsCounter() {
        return this.connections.size();
    }

    public ConnectionDescription getConnection(int id) {
        for (ConnectionDescription conn : this.connections) {
            if (conn.id != id) continue;
            return conn;
        }
        return null;
    }

    public int addConnection(int id, Object obj) throws AlreadyConnected {
        for (ConnectionDescription conn : this.connections) {
            if (!conn.objref.equals(obj)) continue;
            throw new AlreadyConnected();
        }
        ConnectionDescription conn = new ConnectionDescription();
        conn.id = id;
        conn.objref = obj;
        this.connections.add(conn);
        this.desc.connections = this.connections.toArray(new ConnectionDescription[this.connections.size()]);
        return conn.id;
    }

    public void removeConnection(int id) {
        Iterator<ConnectionDescription> iter = this.connections.iterator();
        while (iter.hasNext()) {
            ConnectionDescription conn = iter.next();
            if (conn.id != id) continue;
            iter.remove();
            this.desc.connections = this.connections.toArray(new ConnectionDescription[this.connections.size()]);
            return;
        }
    }
}

