/*
 * Decompiled with CFR 0.152.
 */
package scs.core.servant;

import java.util.ArrayList;
import java.util.Map;
import org.omg.CORBA.Object;
import scs.core.AlreadyConnected;
import scs.core.ConnectionDescription;
import scs.core.ExceededConnectionLimit;
import scs.core.IReceptaclesPOA;
import scs.core.InvalidConnection;
import scs.core.InvalidName;
import scs.core.NoConnection;
import scs.core.servant.ComponentContext;
import scs.core.servant.Receptacle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IReceptaclesServant
extends IReceptaclesPOA {
    private int connectionCounter = 0;
    private final int connectionLimit = 100;
    protected ComponentContext myComponent;

    public IReceptaclesServant(ComponentContext myComponent) {
        this.myComponent = myComponent;
    }

    protected Receptacle findReceptacle(String name) {
        return this.myComponent.getReceptacles().get(name);
    }

    protected Receptacle findReceptacleByConnection(int connId) {
        for (Receptacle rec : this.myComponent.getReceptacles().values()) {
            if (rec.getConnection(connId) == null) continue;
            return rec;
        }
        return null;
    }

    public int connect(String receptacle, Object obj) throws InvalidName, InvalidConnection, AlreadyConnected, ExceededConnectionLimit {
        Receptacle rec = this.findReceptacle(receptacle);
        if (rec == null) {
            throw new InvalidName();
        }
        if (!rec.getReceptacleDescription().is_multiplex && !rec.getConnections().isEmpty()) {
            throw new AlreadyConnected();
        }
        if (this.connectionCounter >= this.connectionLimit) {
            throw new ExceededConnectionLimit();
        }
        if (!obj._is_a(rec.getInterfaceName())) {
            throw new InvalidConnection();
        }
        return rec.addConnection(++this.connectionCounter, obj);
    }

    public void disconnect(int id) throws InvalidConnection, NoConnection {
        if (id < 0) {
            throw new InvalidConnection();
        }
        Receptacle rec = this.findReceptacleByConnection(id);
        if (rec == null) {
            throw new NoConnection();
        }
        rec.removeConnection(id);
    }

    public ConnectionDescription[] getConnections(String receptacle) throws InvalidName {
        Receptacle rec = this.myComponent.getReceptacles().get(receptacle);
        if (rec == null) {
            throw new InvalidName();
        }
        ArrayList<ConnectionDescription> conns = rec.getConnections();
        return conns.toArray(new ConnectionDescription[conns.size()]);
    }

    public Map<String, Receptacle> getReceptacles() {
        return this.myComponent.getReceptacles();
    }

    public Object _get_component() {
        return this.myComponent.getIComponent();
    }
}

