/*
 * Decompiled with CFR 0.152.
 */
package scs.core.servant;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import scs.core.ComponentId;
import scs.core.FacetDescription;
import scs.core.IComponentHelper;
import scs.core.IMetaInterfaceHelper;
import scs.core.IReceptaclesHelper;
import scs.core.ReceptacleDescription;
import scs.core.servant.ComponentContext;
import scs.core.servant.ComponentContextImpl;
import scs.core.servant.ExtendedFacetDescription;
import scs.core.servant.IComponentServant;
import scs.core.servant.IMetaInterfaceServant;
import scs.core.servant.IReceptaclesServant;
import scs.core.servant.Receptacle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentBuilder {
    private POA poa;
    private ORB orb;

    public ComponentBuilder(POA poa, ORB orb) {
        this.poa = poa;
        this.orb = orb;
    }

    private ComponentContext createContext(ComponentId id) throws IllegalArgumentException {
        if (id == null) {
            throw new IllegalArgumentException("ComponentId null!");
        }
        return new ComponentContextImpl(this, id);
    }

    private void testForGetComponent(Class<?> c, String name) {
        try {
            c.getMethod("_get_component", null);
        }
        catch (Exception e) {
            System.err.println("_get_component nao foi definida para a classe " + name + "!");
        }
    }

    private void assemble(ComponentContext context, ExtendedFacetDescription[] facetExtDescs, FacetDescription[] facetDescs, ReceptacleDescription[] receptDescs) throws IllegalArgumentException, ServantNotActive, WrongPolicy, BadKind, SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int i;
        if (facetExtDescs != null) {
            for (i = 0; i < facetExtDescs.length; ++i) {
                context.getExtendedFacetDescs().put(facetExtDescs[i].name, facetExtDescs[i]);
            }
        } else {
            throw new IllegalArgumentException();
        }
        if (facetDescs != null) {
            for (i = 0; i < facetDescs.length; ++i) {
                context.getFacetDescs().put(facetDescs[i].name, facetDescs[i]);
                context.getFacets().put(facetDescs[i].name, facetDescs[i].facet_ref);
            }
        } else {
            this.createFacetDescriptions(context, facetExtDescs);
        }
        if (receptDescs != null) {
            for (i = 0; i < receptDescs.length; ++i) {
                Receptacle rcpt = new Receptacle(receptDescs[i]);
                context.getReceptacles().put(receptDescs[i].name, rcpt);
                context.getReceptacleDescs().put(receptDescs[i].name, receptDescs[i]);
            }
        }
        this.addBasicFacets(context);
    }

    private void createFacetDescriptions(ComponentContext context, ExtendedFacetDescription[] facetExtDescs) throws ClassNotFoundException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ServantNotActive, WrongPolicy {
        if (facetExtDescs != null) {
            for (int i = 0; i < facetExtDescs.length; ++i) {
                ExtendedFacetDescription extDesc = facetExtDescs[i];
                Class<?> c = Class.forName(extDesc.class_name, true, Thread.currentThread().getContextClassLoader());
                this.testForGetComponent(c, extDesc.class_name);
                Object facet = c.getConstructor(ComponentContext.class).newInstance(context);
                if (!(facet instanceof Servant)) continue;
                this.addFacetDescToComponent(context, extDesc, (Servant)facet);
            }
        }
    }

    private void addFacetDescToComponent(ComponentContext context, ExtendedFacetDescription extDesc, Servant facet) throws ServantNotActive, WrongPolicy {
        FacetDescription desc = new FacetDescription();
        desc.name = extDesc.name;
        desc.interface_name = extDesc.interface_name;
        desc.facet_ref = this.poa.servant_to_reference(facet);
        context.getFacetDescs().put(desc.name, desc);
        context.getFacets().put(extDesc.name, facet);
    }

    private void addBasicFacets(ComponentContext context) throws ServantNotActive, WrongPolicy, BadKind {
        ExtendedFacetDescription extDesc;
        Object facet;
        boolean hasIC = false;
        boolean hasIR = false;
        boolean hasIM = false;
        String icId = IComponentHelper.id();
        String irId = IReceptaclesHelper.id();
        String imId = IMetaInterfaceHelper.id();
        for (FacetDescription desc : context.getFacetDescs().values()) {
            if (desc.interface_name == icId) {
                hasIC = true;
            }
            if (desc.interface_name == irId) {
                hasIR = true;
            }
            if (desc.interface_name != imId) continue;
            hasIM = true;
        }
        if (!hasIC) {
            facet = new IComponentServant(context);
            extDesc = new ExtendedFacetDescription(IComponentHelper.type().name(), IComponentHelper.id(), IComponentServant.class.getSimpleName());
            this.addFacetDescToComponent(context, extDesc, (Servant)facet);
            context.getExtendedFacetDescs().put(extDesc.name, extDesc);
        }
        if (!hasIR) {
            facet = new IReceptaclesServant(context);
            extDesc = new ExtendedFacetDescription(IReceptaclesHelper.type().name(), IReceptaclesHelper.id(), IReceptaclesServant.class.getSimpleName());
            this.addFacetDescToComponent(context, extDesc, (Servant)facet);
            context.getExtendedFacetDescs().put(extDesc.name, extDesc);
        }
        if (!hasIM) {
            facet = new IMetaInterfaceServant(context);
            extDesc = new ExtendedFacetDescription(IMetaInterfaceHelper.type().name(), IMetaInterfaceHelper.id(), IMetaInterfaceServant.class.getSimpleName());
            this.addFacetDescToComponent(context, extDesc, (Servant)facet);
            context.getExtendedFacetDescs().put(extDesc.name, extDesc);
        }
    }

    public ComponentContext newComponent(ExtendedFacetDescription[] facetExtDescs, ComponentId id) throws ServantNotActive, WrongPolicy, InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException, BadKind {
        return this.newComponent(facetExtDescs, null, id, null);
    }

    public ComponentContext newComponent(ExtendedFacetDescription[] facetExtDescs, ReceptacleDescription[] receptacleDescs, ComponentId id) throws ServantNotActive, WrongPolicy, InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException, BadKind {
        return this.newComponent(facetExtDescs, receptacleDescs, id, null);
    }

    public ComponentContext newComponent(ExtendedFacetDescription[] facetExtDescs, ReceptacleDescription[] receptacleDescs, ComponentId id, ComponentContext context) throws ServantNotActive, WrongPolicy, InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException, BadKind {
        if (context == null) {
            context = this.createContext(id);
        }
        this.assemble(context, facetExtDescs, null, receptacleDescs);
        return context;
    }

    public ComponentContext newComponent(FacetDescription[] facetDescs, ReceptacleDescription[] receptacleDescs, ComponentId id, ComponentContext context) throws ServantNotActive, WrongPolicy, BadKind, IllegalArgumentException, SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (context == null) {
            context = this.createContext(id);
        }
        ExtendedFacetDescription[] facetExtDescs = new ExtendedFacetDescription[facetDescs.length];
        for (int i = 0; i < facetDescs.length; ++i) {
            ExtendedFacetDescription extDesc;
            FacetDescription desc = facetDescs[i];
            String className = desc.facet_ref.getClass().getCanonicalName();
            facetExtDescs[i] = extDesc = new ExtendedFacetDescription(desc.name, desc.interface_name, className);
        }
        this.assemble(context, facetExtDescs, facetDescs, receptacleDescs);
        return context;
    }

    public Map<String, String> deactivateComponent(ComponentContext context) {
        HashMap<String, String> errMsgs = new HashMap<String, String>();
        for (FacetDescription desc : context.getFacetDescs().values()) {
            try {
                this.poa.deactivate_object(this.poa.reference_to_id(desc.facet_ref));
            }
            catch (Exception e) {
                e.printStackTrace();
                errMsgs.put(desc.name, e.getMessage());
            }
        }
        return errMsgs;
    }

    public static String componentIdToString(ComponentId compid) {
        return compid.name + String.valueOf(compid.major_version) + String.valueOf(compid.minor_version) + String.valueOf(compid.patch_version);
    }

    public POA getPOA() {
        return this.poa;
    }

    public ORB getORB() {
        return this.orb;
    }
}

