
-- the table <map> controls the mapping from virtual paths
-- (used in URLs) to physical paths.
-- each entry in the table specifies how a given virtual path
-- is translated to a physical path:
--
--   { "virtual-path", "physical-path" }, 
--
-- "virtual-path"s are be specified with patterns and may contain captures
-- to be used in the "physical-path".
-- the ordering is important: the map is done with the first matching pattern.
-- for this reason, if there is an entry "/", is must be the last in the table.
-- if the table defines no mapping for a given path,
-- the http server's mapping is used.
-- IMPORTANT:
--   1. to put the character '\' in a Lua string, write it twice: "\\"
--   2. virtual paths starts with '/'
-- 
-- Examples:
--
-- cgilua.map = {
--   { "/", "c:\\website\\cgilua\\scripts\\" }
-- }
--
-- cgilua.map = {
--   { "/~aluno([0-9]*)/", "\\w50aluno%1\\aluno%1\\" }
--   { "/~instrut/", "\\\\w50instrut\\cgilua\\" }
-- }
--
-- cgilua.map = {
--   { "/~([^/]*)/", "/home/i/%1/public/cgilua/" }
--   { "/", "/home/i/tecgraf/cgilua/scripts/" }
-- }
-- cgilua.map = {
--   { "/~([^/]*)/", "\\\\segall\\users\\%1\\cgilua\\" },
-- }

cgilua.map = {
}


-- the variable <default_script> is the name of the file to use
-- as the default CGILua script of a directory

cgilua.default_script = "index.html"


-- the variables <html_mask> and <lua_mask> must contain the pattern matching
-- expression for filename filtering. The default is to process the
-- filenames with extensions '.html' or '.htm' and to execute the
-- filenames with extension '.lua'.

cgilua.html_mask = ".*%.html?$"
cgilua.lua_mask  = ".*%.lua$"


-- the decoded form data are put in the table <cgi>.
-- for each form element the function <insertfield> 
-- is called with the pair <name>,<value>
-- this version of insertfield does not work correctly
-- with a multiple list -- the selections overrides one another

cgi = {}

function cgilua.insertfield( name, value )
  if not cgi[name] then
    cgi[name] = value
  else
    cgi[name] = cgi[name]..','..value
  end
end


