
-- extensions: put here the libraries to be available to the scripts.
-- a library can be a lua file (loaded with <cgilua.dofile>) or
-- a dynamic library (loaded with <loadlibrary>).
-- (see also the function loadlibrary in the documentation).

-- mail function (unix only)
cgilua.dofile( 'mail.lua' )

-- HTML toolkit
cgilua.dofile( 'htmltoolkit.lua' )

-- debug facility
cgilua.dofile( 'cgidb.lua' )

-- date library
loadlibrary( cgilua.directory..'libdate.so', 'datelib_open' )

-- auxiliar library
loadlibrary( cgilua.directory..'libauxiliar.so', 'auxiliarlib_open' )

-- dblua
--cgilua.dofile( 'dblua.lua' )


-- security definitions: here some dangerous functions are
-- removed or redefined to guarantee the safety of the scripts.
-- the definitions depends on the security level required.

-- the function <loadlibrary> is intended to be used 
-- in the configuration file only.
-- to keep it available to the scripts represents
-- that any script can execute any C function (anything).

loadlibrary        = nil


function capture ( cmd )
  local readfrom = getrestricted( readfrom_ref )
  readfrom('|' .. cmd )
  local result  = read( '.*' )
  readfrom()
  return result
end

readfrom_ref = restrict ( readfrom, capture )

eval = capture



-- the original function <execute> let shell comands be invoked.
-- it is redefined to act like every command execution fails,
-- keeping it compatible with the standard definition.

function execute( )
  return -1
end


-- the function <cgilua.nopipe> is used in the redefinition of
-- the functions <writeto> and <readfrom>.
-- both functions accepts a parameter starting with a '|';
-- in this case the input/output is connected to a shell command
-- via a pipe. 
-- the redefined versions fails if the parameter starts with a '|'
-- to prevent shell commands to be invoked.
-- the function <cgilua.nopipe> takes a file (the original parameter)
-- and a reference to a function (<writeto> or <readfrom>),
-- and repasses (or not) the control to the original function.

function cgilua.nopipe( ref, file )
  if type(file) == 'string' and strsub(file, 1, 1) == '|' then
    return nil
  end
  local piped = getrestricted( ref )
  if file then
    return piped( file )
  else
    return piped()
  end
end


-- <cgilua.writeto_ref> and <cgilua.readfrom_ref> are the
-- references to the original functions <writeto> and <readfrom>

cgilua.writeto_ref  = restrict( writeto,  cgilua.nopipe )
cgilua.readfrom_ref = restrict( readfrom, cgilua.nopipe )


-- redefinition of <writeto>

function writeto( file )
  return cgilua.nopipe( cgilua.writeto_ref, file )
end

-- redefinition of <readfrom>

function readfrom( file )
  return cgilua.nopipe( cgilua.readfrom_ref, file )
end


-- definitions for state saving facility

cgilua.max_states    = 2000
cgilua.nstates_remove = 200


-- definitions for compatibility with previous versions

-- version 2.0
cgilua.relative_url = cgilua.relativeurl


